/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="MaintenanceOperationConfig")
public class MaintenanceOperationConfig {
    private final String engineName;
    private final Map<String, String> engineConfig;
    private final String operationName;
    private final Map<String, String> parameters;

    @JsonCreator
    public MaintenanceOperationConfig(@JsonProperty(value="engine-name") String engineName, @JsonProperty(value="engine-config") Map<String, String> engineConfig, @JsonProperty(value="operation-name") String operationName, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.engineName = engineName;
        this.engineConfig = engineConfig;
        this.operationName = operationName;
        this.parameters = parameters;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="engine-name")
    public String getEngineName() {
        return this.engineName;
    }

    @JsonProperty(value="engine-config")
    public Map<String, String> getEngineConfig() {
        return this.engineConfig;
    }

    @JsonProperty(value="operation-name")
    public String getOperationName() {
        return this.operationName;
    }

    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceOperationConfig maintenanceOperationConfig = (MaintenanceOperationConfig)o;
        return Objects.equals(this.engineName, maintenanceOperationConfig.engineName) && Objects.equals(this.engineConfig, maintenanceOperationConfig.engineConfig) && Objects.equals(this.operationName, maintenanceOperationConfig.operationName) && Objects.equals(this.parameters, maintenanceOperationConfig.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.engineName, this.engineConfig, this.operationName, this.parameters);
    }

    public String toString() {
        return "MaintenanceOperationConfig{engineName='" + this.engineName + "', engineConfig='" + String.valueOf(this.engineConfig) + "', operationName='" + this.operationName + "', parameters='" + String.valueOf(this.parameters) + "'}";
    }

    public static class Builder {
        private String engineName;
        private Map<String, String> engineConfig;
        private String operationName;
        private Map<String, String> parameters;

        private Builder() {
        }

        public Builder setEngineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public Builder setEngineConfig(Map<String, String> engineConfig) {
            this.engineConfig = engineConfig;
            return this;
        }

        public Builder setOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public MaintenanceOperationConfig build() {
            return new MaintenanceOperationConfig(this.engineName, this.engineConfig, this.operationName, this.parameters);
        }
    }
}

