/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="IcebergCatalogInfo")
public class IcebergCatalogInfo {
    private final String catalogName;
    private final String description;
    private final String owner;
    private final String fileSystemName;
    private final String fileSystemLocation;
    private final Map<String, String> properties;

    @JsonCreator
    public IcebergCatalogInfo(@JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="description") String description, @JsonProperty(value="owner") String owner, @JsonProperty(value="file-system-name") String fileSystemName, @JsonProperty(value="file-system-location") String fileSystemLocation, @JsonProperty(value="properties") Map<String, String> properties) {
        this.catalogName = catalogName;
        this.description = description;
        this.owner = owner;
        this.fileSystemName = fileSystemName;
        this.fileSystemLocation = fileSystemLocation;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="file-system-name")
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="file-system-location")
    public String getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergCatalogInfo icebergCatalogInfo = (IcebergCatalogInfo)o;
        return Objects.equals(this.catalogName, icebergCatalogInfo.catalogName) && Objects.equals(this.description, icebergCatalogInfo.description) && Objects.equals(this.owner, icebergCatalogInfo.owner) && Objects.equals(this.fileSystemName, icebergCatalogInfo.fileSystemName) && Objects.equals(this.fileSystemLocation, icebergCatalogInfo.fileSystemLocation) && Objects.equals(this.properties, icebergCatalogInfo.properties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.description, this.owner, this.fileSystemName, this.fileSystemLocation, this.properties);
    }

    public String toString() {
        return "IcebergCatalogInfo{catalogName='" + this.catalogName + "', description='" + this.description + "', owner='" + this.owner + "', fileSystemName='" + this.fileSystemName + "', fileSystemLocation='" + this.fileSystemLocation + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String catalogName;
        private String description;
        private String owner;
        private String fileSystemName;
        private String fileSystemLocation;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setFileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setFileSystemLocation(String fileSystemLocation) {
            this.fileSystemLocation = fileSystemLocation;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public IcebergCatalogInfo build() {
            return new IcebergCatalogInfo(this.catalogName, this.description, this.owner, this.fileSystemName, this.fileSystemLocation, this.properties);
        }
    }
}

