/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="FileSystemUpdateRequest")
public class FileSystemUpdateRequest {
    private final StringValue fileSystemName;
    private final StringValue description;
    private final Map<String, String> updatedProperties;
    private final Set<String> removedProperties;

    @JsonCreator
    public FileSystemUpdateRequest(@JsonProperty(value="file-system-name") StringValue fileSystemName, @JsonProperty(value="description") StringValue description, @JsonProperty(value="updated-properties") Map<String, String> updatedProperties, @JsonProperty(value="removed-properties") Set<String> removedProperties) {
        this.fileSystemName = fileSystemName;
        this.description = description;
        this.updatedProperties = updatedProperties;
        this.removedProperties = removedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="file-system-name")
    public StringValue getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    @JsonProperty(value="updated-properties")
    public Map<String, String> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @JsonProperty(value="removed-properties")
    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemUpdateRequest fileSystemUpdateRequest = (FileSystemUpdateRequest)o;
        return Objects.equals(this.fileSystemName, fileSystemUpdateRequest.fileSystemName) && Objects.equals(this.description, fileSystemUpdateRequest.description) && Objects.equals(this.updatedProperties, fileSystemUpdateRequest.updatedProperties) && Objects.equals(this.removedProperties, fileSystemUpdateRequest.removedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystemName, this.description, this.updatedProperties, this.removedProperties);
    }

    public String toString() {
        return "FileSystemUpdateRequest{fileSystemName='" + String.valueOf(this.fileSystemName) + "', description='" + String.valueOf(this.description) + "', updatedProperties='" + String.valueOf(this.updatedProperties) + "', removedProperties='" + String.valueOf(this.removedProperties) + "'}";
    }

    public static class Builder {
        private StringValue fileSystemName;
        private StringValue description;
        private Map<String, String> updatedProperties;
        private Set<String> removedProperties;

        private Builder() {
        }

        public Builder setFileSystemName(StringValue fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public Builder setUpdatedProperties(Map<String, String> updatedProperties) {
            this.updatedProperties = updatedProperties;
            return this;
        }

        public Builder setRemovedProperties(Set<String> removedProperties) {
            this.removedProperties = removedProperties;
            return this;
        }

        public FileSystemUpdateRequest build() {
            return new FileSystemUpdateRequest(this.fileSystemName, this.description, this.updatedProperties, this.removedProperties);
        }
    }
}

