/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;

@JsonTypeName(value="FileSystemListResponse")
public class FileSystemListResponse {
    private final List<FileSystemInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public FileSystemListResponse(@JsonProperty(value="items") List<FileSystemInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<FileSystemInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemListResponse fileSystemListResponse = (FileSystemListResponse)o;
        return Objects.equals(this.items, fileSystemListResponse.items) && Objects.equals(this.nextPageToken, fileSystemListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "FileSystemListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<FileSystemInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<FileSystemInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public FileSystemListResponse build() {
            return new FileSystemListResponse(this.items, this.nextPageToken);
        }
    }
}

