/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.Securable;

@JsonTypeName(value="CheckAccessRequest")
public class CheckAccessRequest {
    private final String principalName;
    private final String action;
    private final Securable securable;

    @JsonCreator
    public CheckAccessRequest(@JsonProperty(value="principal-name") String principalName, @JsonProperty(value="action") String action, @JsonProperty(value="securable") Securable securable) {
        this.principalName = principalName;
        this.action = action;
        this.securable = securable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="securable")
    public Securable getSecurable() {
        return this.securable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckAccessRequest checkAccessRequest = (CheckAccessRequest)o;
        return Objects.equals(this.principalName, checkAccessRequest.principalName) && Objects.equals(this.action, checkAccessRequest.action) && Objects.equals(this.securable, checkAccessRequest.securable);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.action, this.securable);
    }

    public String toString() {
        return "CheckAccessRequest{principalName='" + this.principalName + "', action='" + this.action + "', securable='" + String.valueOf(this.securable) + "'}";
    }

    public static class Builder {
        private String principalName;
        private String action;
        private Securable securable;

        private Builder() {
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setSecurable(Securable securable) {
            this.securable = securable;
            return this;
        }

        public CheckAccessRequest build() {
            return new CheckAccessRequest(this.principalName, this.action, this.securable);
        }
    }
}

