/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception.iceberg;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.iceberg.AbstractIcebergCatalogException;

public class IcebergNamespaceDoesNotExistException
extends AbstractIcebergCatalogException {
    public static final String PROPERTY_ICEBERG_NAMESPACE_NAME = "iceberg-namespace-name";

    public IcebergNamespaceDoesNotExistException(String namespaceName) {
        super(CatalogErrorCode.ICEBERG_NAMESPACE_DOESNT_EXIST, String.format("Iceberg namespace \"%s\" does not exist", namespaceName), IcebergNamespaceDoesNotExistException.toDetails(namespaceName));
    }

    public IcebergNamespaceDoesNotExistException(String message, Map<String, String> details) {
        super(CatalogErrorCode.ICEBERG_NAMESPACE_DOESNT_EXIST, message, details);
    }

    private static Map<String, String> toDetails(String namespaceName) {
        return Map.of(PROPERTY_ICEBERG_NAMESPACE_NAME, namespaceName);
    }
}

