/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class CatalogSecurityProviderInUseException
extends CatalogException {
    public static final String PROPERTY_SECURITY_PROVIDER_NAME = "security-provider-name";

    public CatalogSecurityProviderInUseException(String securityProviderName) {
        super(CatalogErrorCode.SECURITY_PROVIDER_IN_USE, String.format("Security provider \"%s\" is used for user authentication", securityProviderName), Map.of(PROPERTY_SECURITY_PROVIDER_NAME, securityProviderName));
    }

    public CatalogSecurityProviderInUseException(String message, Map<String, String> details) {
        super(CatalogErrorCode.SECURITY_PROVIDER_IN_USE, message, details);
    }
}

