/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class CatalogPrincipalDoesNotExistException
extends CatalogException {
    public static final String PROPERTY_PRINCIPAL_NAME = "principal-name";

    public CatalogPrincipalDoesNotExistException(String principalName) {
        super(CatalogErrorCode.PRINCIPAL_DOESNT_EXIST, String.format("Principal \"%s\" does not exist", principalName), CatalogPrincipalDoesNotExistException.toDetails(principalName));
    }

    public CatalogPrincipalDoesNotExistException(String message, Map<String, String> details) {
        super(CatalogErrorCode.PRINCIPAL_DOESNT_EXIST, message, details);
    }

    private static Map<String, String> toDetails(String principalName) {
        return Map.of(PROPERTY_PRINCIPAL_NAME, principalName);
    }
}

