/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.ConfigurationInitializer;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoFileSystemCacheStats;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import io.trino.hdfs.gcs.GcsStorageFactory;
import org.weakref.jmx.guice.ExportBinder;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemConfig;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemKerberosAuthenticationModule;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemSimpleAuthenticationModule;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsTrinoFileSystemFactory;

public class CatalogHdfsFileSystemModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogHdfsFileSystemConfig.class);
        binder.bind(HdfsFileSystemFactory.class).in(Scopes.SINGLETON);
        binder.bind(TrinoHdfsFileSystemStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TrinoHdfsFileSystemStats.class).withGeneratedName();
        binder.bind(HdfsConfiguration.class).to(DynamicHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(TrinoFileSystemCacheStats.class).toInstance((Object)TrinoFileSystemCacheStats.instance());
        ExportBinder.newExporter((Binder)binder).export(TrinoFileSystemCacheStats.class).withGeneratedName();
        binder.bind(HdfsConfigurationInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class);
        OptionalBinder.newOptionalBinder((Binder)binder, GcsStorageFactory.class);
        CatalogHdfsFileSystemConfig config = (CatalogHdfsFileSystemConfig)this.buildConfigObject(CatalogHdfsFileSystemConfig.class);
        if (config.getKerberosPrincipal() != null) {
            binder.install((Module)new CatalogHdfsFileSystemKerberosAuthenticationModule(config.isImpersonationEnabled()));
        } else {
            binder.install((Module)new CatalogHdfsFileSystemSimpleAuthenticationModule(config.isImpersonationEnabled()));
        }
        binder.bind(CatalogHdfsTrinoFileSystemFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public HdfsConfig getHdfsConfig(CatalogHdfsFileSystemConfig fileSystemConfig) {
        return new HdfsConfig().setResourceConfigFiles(fileSystemConfig.getResourceConfigFiles());
    }
}

