/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataEngine;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataEngineConfig;

public class CatalogCedrusDataEngineModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogCedrusDataEngineConfig.class);
        binder.bind(CatalogCedrusDataEngine.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public DataSource dataSource(CatalogCedrusDataEngineConfig config) {
        Set<String> connectionParameters = this.connectionParameters(config.getJdbcUrl());
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(config.getConnectionPoolSize());
        hikariConfig.setJdbcUrl(config.getJdbcUrl());
        hikariConfig.setThreadFactory(Threads.daemonThreadsNamed((String)"hikari-cedrusdata-engine-%d"));
        if (!connectionParameters.contains("source")) {
            hikariConfig.addDataSourceProperty("source", (Object)"cedrusdata-maintenance");
        }
        if (!connectionParameters.contains("explicitPrepare")) {
            hikariConfig.addDataSourceProperty("explicitPrepare", (Object)false);
        }
        return new HikariDataSource(hikariConfig);
    }

    private Set<String> connectionParameters(String jdbcUrl) {
        try {
            String[] queryParameters;
            URI uri = new URI(jdbcUrl.replaceFirst("^jdbc:", ""));
            String query = uri.getQuery();
            if (query == null) {
                return Collections.emptySet();
            }
            HashSet<String> connectionParameters = new HashSet<String>();
            for (String queryParameter : queryParameters = query.split("&")) {
                String[] parts = queryParameter.split("=");
                if (parts.length != 2) continue;
                connectionParameters.add(parts[0]);
            }
            return connectionParameters;
        }
        catch (URISyntaxException e) {
            return Collections.emptySet();
        }
    }
}

