/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.concurrent.MoreFutures;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

@ThreadSafe
public class AsyncSemaphore<T, R> {
    private final Queue<QueuedTask<T, R>> queuedTasks = new ConcurrentLinkedQueue<QueuedTask<T, R>>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Runnable runNextTask = this::runNext;
    private final int maxPermits;
    private final Executor submitExecutor;
    private final Function<T, ListenableFuture<R>> submitter;

    public static <T, R> ListenableFuture<List<R>> processAll(List<T> tasks, Function<T, ListenableFuture<R>> submitter, int maxConcurrency, Executor submitExecutor) {
        SettableFuture resultFuture = SettableFuture.create();
        AsyncSemaphore<Object, R> semaphore = new AsyncSemaphore<Object, R>(maxConcurrency, submitExecutor, task -> {
            if (resultFuture.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            return (ListenableFuture)submitter.apply(task);
        });
        resultFuture.setFuture(MoreFutures.allAsListWithCancellationOnFailure((Iterable)tasks.stream().map(semaphore::submit).collect(ImmutableList.toImmutableList())));
        return resultFuture;
    }

    public AsyncSemaphore(int maxPermits, Executor submitExecutor, Function<T, ListenableFuture<R>> submitter) {
        Preconditions.checkArgument((maxPermits > 0 ? 1 : 0) != 0, (Object)"must have at least one permit");
        this.maxPermits = maxPermits;
        this.submitExecutor = Objects.requireNonNull(submitExecutor, "submitExecutor is null");
        this.submitter = Objects.requireNonNull(submitter, "submitter is null");
    }

    public ListenableFuture<R> submit(T task) {
        QueuedTask queuedTask = new QueuedTask(task);
        this.queuedTasks.add(queuedTask);
        this.acquirePermit();
        return queuedTask.getCompletionFuture();
    }

    private void acquirePermit() {
        if (this.counter.incrementAndGet() <= this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void releasePermit() {
        if (this.counter.getAndDecrement() > this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void runNext() {
        QueuedTask<T, R> queuedTask = this.queuedTasks.poll();
        Verify.verify((queuedTask != null ? 1 : 0) != 0);
        if (!queuedTask.getCompletionFuture().isDone()) {
            queuedTask.setFuture(this.submitTask(queuedTask.getTask()));
        }
        queuedTask.getCompletionFuture().addListener(this::releasePermit, MoreExecutors.directExecutor());
    }

    private ListenableFuture<R> submitTask(T task) {
        try {
            ListenableFuture<R> future = this.submitter.apply(task);
            if (future == null) {
                return Futures.immediateFailedFuture((Throwable)new NullPointerException("Submitter returned a null future for task: " + String.valueOf(task)));
            }
            return future;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private static class QueuedTask<T, R> {
        private final T task;
        private final SettableFuture<R> settableFuture = SettableFuture.create();

        private QueuedTask(T task) {
            this.task = Objects.requireNonNull(task, "task is null");
        }

        public T getTask() {
            return this.task;
        }

        public void setFuture(ListenableFuture<R> future) {
            this.settableFuture.setFuture(future);
        }

        public ListenableFuture<R> getCompletionFuture() {
            return this.settableFuture;
        }
    }
}

