/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.KerberosHadoopAuthentication;
import io.trino.plugin.base.authentication.KerberosTicketUtils;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.security.UserGroupInformation;

public class CachingKerberosHadoopAuthentication
implements HadoopAuthentication {
    private final KerberosHadoopAuthentication delegate;
    private final UserGroupInformation userGroupInformation;
    @GuardedBy(value="this")
    private long nextRefreshTime;

    public CachingKerberosHadoopAuthentication(KerberosHadoopAuthentication delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.userGroupInformation = Objects.requireNonNull(delegate.getUserGroupInformation(), "delegate.getUserGroupInformation() is null");
        this.nextRefreshTime = CachingKerberosHadoopAuthentication.calculateNextRefreshTime(this.userGroupInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized UserGroupInformation getUserGroupInformation() {
        if (this.nextRefreshTime < System.currentTimeMillis()) {
            Set<Object> publicCredentials;
            Set<Object> privateCredentials;
            Subject existingSubject = this.userGroupInformation.getSubject();
            UserGroupInformation newUserGroupInformation = Objects.requireNonNull(this.delegate.getUserGroupInformation(), "delegate.getUserGroupInformation() is null");
            Subject newSubject = newUserGroupInformation.getSubject();
            existingSubject.getPrincipals().addAll(newSubject.getPrincipals());
            Set<Object> set = privateCredentials = existingSubject.getPrivateCredentials();
            synchronized (set) {
                privateCredentials.clear();
                privateCredentials.addAll(newSubject.getPrivateCredentials());
            }
            Set<Object> set2 = publicCredentials = existingSubject.getPublicCredentials();
            synchronized (set2) {
                publicCredentials.clear();
                publicCredentials.addAll(newSubject.getPublicCredentials());
            }
            this.nextRefreshTime = CachingKerberosHadoopAuthentication.calculateNextRefreshTime(newUserGroupInformation);
        }
        return this.userGroupInformation;
    }

    private static long calculateNextRefreshTime(UserGroupInformation userGroupInformation) {
        Subject subject = userGroupInformation.getSubject();
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"subject must be present in kerberos based UGI");
        KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket((Subject)subject);
        return KerberosTicketUtils.getRefreshTime((KerberosTicket)tgtTicket);
    }
}

