/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileSystemFinalizerService {
    private static final Logger log = Logger.get(FileSystemFinalizerService.class);
    private static Optional<FileSystemFinalizerService> instance = Optional.empty();
    private final Set<FinalizerReference> finalizers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> finalizerQueue = new ReferenceQueue();
    private Thread finalizerThread;
    private volatile boolean shutdown;

    private FileSystemFinalizerService() {
    }

    public static synchronized FileSystemFinalizerService getInstance() {
        if (instance.isEmpty()) {
            FileSystemFinalizerService finalizer = new FileSystemFinalizerService();
            finalizer.start();
            instance = Optional.of(finalizer);
        }
        return instance.get();
    }

    public static synchronized void shutdown() {
        instance.ifPresent(FileSystemFinalizerService::doShutdown);
    }

    public synchronized void doShutdown() {
        this.shutdown = true;
        this.finalizerThread.interrupt();
    }

    private void start() {
        if (this.finalizerThread != null) {
            return;
        }
        this.finalizerThread = new Thread(this::processFinalizerQueue);
        this.finalizerThread.setDaemon(true);
        this.finalizerThread.setName("FileSystemFinalizerService");
        this.finalizerThread.setUncaughtExceptionHandler((thread, e) -> log.error(e, "Uncaught exception in finalizer thread"));
        this.finalizerThread.start();
    }

    public synchronized void addFinalizer(Object referent, Runnable cleanup) {
        Objects.requireNonNull(referent, "referent is null");
        Objects.requireNonNull(cleanup, "cleanup is null");
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"FileSystemFinalizerService is shutdown");
        this.finalizers.add(new FinalizerReference(referent, this.finalizerQueue, cleanup));
    }

    private void processFinalizerQueue() {
        while (!Thread.interrupted() && !this.shutdown) {
            try {
                FinalizerReference finalizer = (FinalizerReference)this.finalizerQueue.remove();
                this.finalizers.remove(finalizer);
                finalizer.cleanup();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable t) {
                log.error(t, "Finalizer cleanup failed");
            }
        }
    }

    private static class FinalizerReference
    extends PhantomReference<Object> {
        private final Runnable cleanup;
        private final AtomicBoolean executed = new AtomicBoolean();

        public FinalizerReference(Object referent, ReferenceQueue<Object> queue, Runnable cleanup) {
            super(Objects.requireNonNull(referent, "referent is null"), Objects.requireNonNull(queue, "queue is null"));
            this.cleanup = Objects.requireNonNull(cleanup, "cleanup is null");
        }

        public void cleanup() {
            if (this.executed.compareAndSet(false, true)) {
                this.cleanup.run();
            }
        }
    }
}

