/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.Location;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataOutputStream;

class HdfsOutputStream
extends FSDataOutputStream {
    private final Location location;
    private final HdfsEnvironment environment;
    private final ConnectorIdentity identity;
    private boolean closed;

    public HdfsOutputStream(Location location, FSDataOutputStream out, HdfsEnvironment environment, HdfsContext context) {
        super((OutputStream)out, null, out.getPos());
        this.location = Objects.requireNonNull(location, "location is null");
        this.environment = environment;
        this.identity = context.getIdentity();
    }

    public OutputStream getWrappedStream() {
        return ((FSDataOutputStream)super.getWrappedStream()).getWrappedStream();
    }

    public void write(int b) throws IOException {
        this.ensureOpen();
        this.environment.doAs(this.identity, () -> {
            super.write(b);
            return null;
        });
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.environment.doAs(this.identity, () -> {
            super.write(b, off, len);
            return null;
        });
    }

    public void flush() throws IOException {
        this.ensureOpen();
        super.flush();
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + String.valueOf(this.location));
        }
    }
}

