CREATE TABLE metastore_maintenance_operation(
    engine_id UUID,
    operation_id UUID PRIMARY KEY,
    operation_name VARCHAR NOT NULL,
    operation_parameters TEXT,
    target_object_group_id UUID,
    target_object_id UUID,
    owner_id UUID,
    started_at BIGINT NOT NULL,
    completed_at BIGINT,
    result TEXT,
    error VARCHAR,
    FOREIGN KEY (engine_id) REFERENCES metastore_compute_engine(engine_id) ON DELETE SET NULL,
    FOREIGN KEY (target_object_group_id) REFERENCES metastore_object_group(group_id) ON DELETE SET NULL,
    FOREIGN KEY (target_object_id) REFERENCES metastore_iceberg_table(table_id) ON DELETE SET NULL,
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id) ON DELETE SET NULL
);

-- Index to allow for fast listing ordered by the most recent operations
CREATE INDEX metastore_maintenance_operation_idx_started_at ON metastore_maintenance_operation(started_at DESC, operation_id);

-- Index to avoid full scans when removing outdated entries
CREATE INDEX metastore_maintenance_operation_idx_completed_at ON metastore_maintenance_operation(completed_at, operation_id);
