CREATE TABLE metastore_maintenance_job(
    job_id UUID PRIMARY KEY,
    job_name VARCHAR NOT NULL UNIQUE,
    schedule_expression VARCHAR NOT NULL,
    schedule_timezone_id VARCHAR,
    description VARCHAR,
    operation_name VARCHAR NOT NULL,
    operation_parameters TEXT,
    operation_engine_id UUID,
    target_object_group_id UUID,
    run_as_principal_id UUID NOT NULL,
    owner_id UUID NOT NULL,
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id),
    FOREIGN KEY (run_as_principal_id) REFERENCES metastore_principal(principal_id),
    FOREIGN KEY (target_object_group_id) REFERENCES metastore_object_group(group_id),
    FOREIGN KEY (operation_engine_id) REFERENCES metastore_compute_engine(engine_id) ON DELETE CASCADE
);

ALTER TABLE metastore_maintenance_operation ADD COLUMN job_id UUID REFERENCES metastore_maintenance_job(job_id) ON DELETE SET NULL;

-- Index for fast lookup of the last job operation
CREATE INDEX metastore_maintenance_operation_idx_job_id_started_at ON metastore_maintenance_operation(job_id, started_at DESC);
