CREATE TABLE metastore_table_group
(
    group_id UUID PRIMARY KEY,
    group_name VARCHAR NOT NULL UNIQUE,
    catalog_name VARCHAR NOT NULL,
    type INT NOT NULL,
    description VARCHAR,
    properties TEXT,
    namespace_name_pattern VARCHAR,
    table_name_pattern VARCHAR
);

CREATE TABLE metastore_table_group_namespace
(
    id UUID,
    group_id UUID,
    namespace_name VARCHAR NOT NULL,
    UNIQUE (group_id, namespace_name),
    FOREIGN KEY (group_id) REFERENCES metastore_table_group (group_id) ON DELETE CASCADE
);

CREATE TABLE metastore_table_group_table
(
    id UUID,
    group_id UUID,
    namespace_name VARCHAR NOT NULL,
    table_name VARCHAR NOT NULL,
    UNIQUE (group_id, namespace_name, table_name),
    FOREIGN KEY (group_id) REFERENCES metastore_table_group (group_id) ON DELETE CASCADE
);
