/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.QueryId;
import io.trino.spi.security.Identity;
import java.time.Instant;
import java.util.Objects;

public class SystemSecurityContext {
    private final Identity identity;
    private final QueryId queryId;
    private final Instant queryStart;

    public SystemSecurityContext(Identity identity, QueryId queryId, Instant queryStart) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.queryStart = Objects.requireNonNull(queryStart, "queryStart is null");
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Instant getQueryStart() {
        return this.queryStart;
    }
}

