/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public class SqlMap {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SqlMap.class);
    private final MapType mapType;
    private final Block rawKeyBlock;
    private final Block rawValueBlock;
    private final HashTableSupplier hashTablesSupplier;
    private final int offset;
    private final int size;

    public SqlMap(MapType mapType, MapHashTables.HashBuildMode mode, Block keyBlock, Block valueBlock) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Key and value blocks have different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        this.rawKeyBlock = keyBlock;
        this.rawValueBlock = valueBlock;
        this.offset = 0;
        this.size = keyBlock.getPositionCount();
        this.hashTablesSupplier = new HashTableSupplier(MapHashTables.createSingleTable(mapType, mode, keyBlock).get());
    }

    SqlMap(MapType mapType, Block rawKeyBlock, Block rawValueBlock, HashTableSupplier hashTablesSupplier, int offset, int size) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
        this.rawKeyBlock = Objects.requireNonNull(rawKeyBlock, "rawKeyBlock is null");
        this.rawValueBlock = Objects.requireNonNull(rawValueBlock, "rawValueBlock is null");
        this.hashTablesSupplier = Objects.requireNonNull(hashTablesSupplier, "hashTablesSupplier is null");
        Objects.checkFromIndexSize(offset, size, rawKeyBlock.getPositionCount());
        Objects.checkFromIndexSize(offset, size, rawValueBlock.getPositionCount());
        this.offset = offset;
        this.size = size;
    }

    public Type getMapType() {
        return this.mapType;
    }

    public int getSize() {
        return this.size;
    }

    public int getRawOffset() {
        return this.offset;
    }

    public Block getRawKeyBlock() {
        return this.rawKeyBlock;
    }

    public Block getRawValueBlock() {
        return this.rawValueBlock;
    }

    public int getUnderlyingKeyPosition(int position) {
        return this.rawKeyBlock.getUnderlyingValuePosition(this.offset + position);
    }

    public ValueBlock getUnderlyingKeyBlock() {
        return this.rawKeyBlock.getUnderlyingValueBlock();
    }

    public int getUnderlyingValuePosition(int position) {
        return this.rawValueBlock.getUnderlyingValuePosition(this.offset + position);
    }

    public ValueBlock getUnderlyingValueBlock() {
        return this.rawValueBlock.getUnderlyingValueBlock();
    }

    public String toString() {
        return String.format("SqlMap{size=%d}", this.size);
    }

    public int seekKey(Object nativeValue) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        if (nativeValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        try {
            hashCode = this.mapType.getKeyNativeHashCode().invoke(nativeValue);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapType.getKeyBlockNativeEqual().invoke(this.rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKey(MethodHandle keyEqualOperator, MethodHandle keyHashOperator, Block targetKeyBlock, int targetKeyPosition) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        SqlMap.checkKeyNotNull(targetKeyBlock, targetKeyPosition);
        try {
            hashCode = keyHashOperator.invoke(targetKeyBlock, targetKeyPosition);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = keyEqualOperator.invoke(this.rawKeyBlock, rawKeyPosition, targetKeyBlock, targetKeyPosition);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(long nativeValue) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        try {
            hashCode = this.mapType.getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapType.getKeyBlockNativeEqual().invokeExact(this.rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(boolean nativeValue) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        try {
            hashCode = this.mapType.getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapType.getKeyBlockNativeEqual().invokeExact(this.rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(double nativeValue) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        try {
            hashCode = this.mapType.getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapType.getKeyBlockNativeEqual().invokeExact(this.rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Object nativeValue) {
        long hashCode;
        if (this.size == 0) {
            return -1;
        }
        if (nativeValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
        int[] hashTable = this.hashTablesSupplier.getHashTables();
        try {
            hashCode = this.mapType.getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SqlMap.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset * 2;
        int hashTableSize = this.size * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset + keyPosition;
            SqlMap.checkKeyNotNull(this.rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapType.getKeyBlockNativeEqual().invokeExact(this.rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SqlMap.handleThrowable(throwable);
            }
            SqlMap.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    private static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof TrinoException) {
            throw (TrinoException)throwable;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
    }

    private static void checkKeyNotNull(Block keyBlock, int positionCount) {
        if (keyBlock.isNull(positionCount)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
    }

    private static void checkNotIndeterminate(Boolean equalResult) {
        if (equalResult == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
    }

    public long getSizeInBytes() {
        return this.rawKeyBlock.getRegionSizeInBytes(this.offset, this.size) + this.rawValueBlock.getRegionSizeInBytes(this.offset, this.size) + SizeOf.sizeOfIntArray((int)(this.size * 2));
    }

    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.rawKeyBlock.getRetainedSizeInBytes() + this.rawValueBlock.getRetainedSizeInBytes() + this.hashTablesSupplier.tryGetHashTable().map(SizeOf::sizeOf).orElse(0L);
        return size;
    }

    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this, INSTANCE_SIZE);
        consumer.accept(this.rawKeyBlock, this.rawKeyBlock.getRetainedSizeInBytes());
        consumer.accept(this.rawValueBlock, this.rawValueBlock.getRetainedSizeInBytes());
        this.hashTablesSupplier.tryGetHashTable().ifPresent(hashTables -> consumer.accept(hashTables, SizeOf.sizeOf((int[])hashTables)));
    }

    static class HashTableSupplier {
        private MapBlock mapBlock;
        private int[] hashTables;

        public HashTableSupplier(MapBlock mapBlock) {
            this.hashTables = mapBlock.getHashTables().tryGet().orElse(null);
            if (this.hashTables == null) {
                this.mapBlock = mapBlock;
            }
        }

        public HashTableSupplier(int[] hashTables) {
            this.hashTables = Objects.requireNonNull(hashTables, "hashTables is null");
        }

        public Optional<int[]> tryGetHashTable() {
            if (this.hashTables == null) {
                this.hashTables = this.mapBlock.getHashTables().tryGet().orElse(null);
            }
            return Optional.ofNullable(this.hashTables);
        }

        public int[] getHashTables() {
            if (this.hashTables == null) {
                this.mapBlock.ensureHashTableLoaded();
                this.hashTables = this.mapBlock.getHashTables().get();
            }
            return this.hashTables;
        }
    }
}

