/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.inject.Inject;
import io.trino.hdfs.ConfigurationInitializer;
import io.trino.hdfs.gcs.GcsAccessTokenProvider;
import io.trino.hdfs.gcs.HiveGcsConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;

public class GoogleGcsConfigurationInitializer
implements ConfigurationInitializer {
    private final boolean useGcsAccessToken;
    private final String jsonKeyFilePath;

    @Inject
    public GoogleGcsConfigurationInitializer(HiveGcsConfig config) {
        config.validate();
        this.useGcsAccessToken = config.isUseGcsAccessToken();
        this.jsonKeyFilePath = Optional.ofNullable(config.getJsonKey()).map(GoogleGcsConfigurationInitializer::getJsonKeyFilePath).orElse(config.getJsonKeyFilePath());
    }

    private static String getJsonKeyFilePath(String jsonKey) {
        try {
            Path tempFile = Files.createTempFile("gcs-key-", ".json", PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
            tempFile.toFile().deleteOnExit();
            Files.writeString(tempFile, (CharSequence)jsonKey, StandardCharsets.UTF_8, new OpenOption[0]);
            return tempFile.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create a temp file for the GCS JSON key", e);
        }
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        config.set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        if (this.useGcsAccessToken) {
            config.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), false);
            config.setClass("fs.gs" + HadoopCredentialConfiguration.ACCESS_TOKEN_PROVIDER_IMPL_SUFFIX.getKey(), GcsAccessTokenProvider.class, AccessTokenProvider.class);
        } else if (this.jsonKeyFilePath != null) {
            config.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), true);
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), this.jsonKeyFilePath);
        }
    }
}

