/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.cos;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.cos.HiveCosServiceConfig;
import io.trino.hdfs.cos.ServiceConfig;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class CosServiceConfigurationProvider
implements DynamicConfigurationProvider {
    private final Map<String, ServiceConfig> services;

    @Inject
    public CosServiceConfigurationProvider(HiveCosServiceConfig config) {
        this.services = ServiceConfig.loadServiceConfigs(config.getServiceConfig());
    }

    @Override
    public void updateConfiguration(Configuration configuration, HdfsContext context, URI uri) {
        if (!"cos".equals(uri.getScheme())) {
            return;
        }
        List parts = Splitter.on((char)'.').limit(2).splitToList((CharSequence)uri.getHost());
        if (parts.size() != 2) {
            return;
        }
        String serviceName = (String)parts.get(1);
        ServiceConfig service = this.services.get(serviceName);
        if (service == null) {
            return;
        }
        configuration.set("trino.s3.access-key", service.getAccessKey());
        configuration.set("trino.s3.secret-key", service.getSecretKey());
        service.getEndpoint().ifPresent(endpoint -> configuration.set("trino.s3.endpoint", endpoint));
        DynamicConfigurationProvider.setCacheKey(configuration, serviceName);
    }
}

