/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import com.google.inject.Inject;
import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;

public class DirectHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;

    @Inject
    public DirectHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
    }

    @Override
    public <T> T doAs(ConnectorIdentity identity, HdfsAuthentication.ExceptionAction<T> action) throws IOException {
        try {
            return (T)this.hadoopAuthentication.getUserGroupInformation().callAs(action::run);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }
}

