/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.type;

import io.trino.plugin.base.type.LongTimestampEncoder;
import io.trino.plugin.base.type.ShortTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public final class TrinoTimestampEncoderFactory {
    private TrinoTimestampEncoderFactory() {
    }

    public static TrinoTimestampEncoder<? extends Comparable<?>> createTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(timeZone, "timeZoneKey is null");
        if (type.isShort()) {
            return new ShortTimestampEncoder(type, timeZone);
        }
        return new LongTimestampEncoder(type, timeZone);
    }

    static LongTimestamp longTimestamp(long epochSecond, long fractionInPicos) {
        return new LongTimestamp(Math.addExact(Math.multiplyExact(epochSecond, 1000000), fractionInPicos / 1000000L), (int)(fractionInPicos % 1000000L));
    }
}

