/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMappingRules;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.base.mapping.SchemaMappingRule;
import io.trino.plugin.base.mapping.TableMappingRule;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;

public class RuleBasedIdentifierMapping
implements IdentifierMapping {
    private final Map<String, String> fromRemoteSchema;
    private final Map<String, String> toRemoteSchema;
    private final Table<String, String, String> fromRemoteTable;
    private final Table<String, String, String> toRemoteTable;
    private final IdentifierMapping delegate;

    public RuleBasedIdentifierMapping(IdentifierMappingRules rules, IdentifierMapping delegate) {
        Objects.requireNonNull(rules, "rules is null");
        Objects.requireNonNull(delegate, "defaultIdentifierMapping is null");
        this.fromRemoteSchema = (Map)rules.getSchemaMapping().stream().collect(ImmutableMap.toImmutableMap(SchemaMappingRule::getRemoteSchema, SchemaMappingRule::getMapping));
        this.toRemoteSchema = (Map)rules.getSchemaMapping().stream().collect(ImmutableMap.toImmutableMap(SchemaMappingRule::getMapping, SchemaMappingRule::getRemoteSchema));
        this.fromRemoteTable = (Table)rules.getTableMapping().stream().collect(ImmutableTable.toImmutableTable(TableMappingRule::getRemoteSchema, TableMappingRule::getRemoteTable, TableMappingRule::getMapping));
        this.toRemoteTable = (Table)rules.getTableMapping().stream().collect(ImmutableTable.toImmutableTable(TableMappingRule::getRemoteSchema, TableMappingRule::getMapping, TableMappingRule::getRemoteTable));
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        String schemaName = this.fromRemoteSchema.get(remoteSchemaName);
        if (schemaName == null) {
            schemaName = this.delegate.fromRemoteSchemaName(remoteSchemaName);
        }
        return schemaName;
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        String tableName = (String)this.fromRemoteTable.get((Object)remoteSchemaName, (Object)remoteTableName);
        if (tableName == null) {
            tableName = this.delegate.fromRemoteTableName(remoteSchemaName, remoteTableName);
        }
        return tableName;
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.delegate.fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String schemaName) {
        String remoteSchemaName = this.toRemoteSchema.get(schemaName);
        if (remoteSchemaName == null) {
            remoteSchemaName = this.delegate.toRemoteSchemaName(remoteIdentifiers, identity, schemaName);
        }
        return remoteSchemaName;
    }

    @Override
    public String toRemoteTableName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String remoteSchema, String tableName) {
        String remoteTableName = (String)this.toRemoteTable.get((Object)remoteSchema, (Object)tableName);
        if (remoteTableName == null) {
            remoteTableName = this.delegate.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, tableName);
        }
        return remoteTableName;
    }

    @Override
    public String toRemoteColumnName(RemoteIdentifiers remoteIdentifiers, String columnName) {
        return this.delegate.toRemoteColumnName(remoteIdentifiers, columnName);
    }
}

