/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import java.util.Objects;
import java.util.Optional;

public final class ColumnStatistics {
    private static final ColumnStatistics EMPTY = new ColumnStatistics(Estimate.unknown(), Estimate.unknown(), Estimate.unknown(), Optional.empty());
    private final Estimate nullsFraction;
    private final Estimate distinctValuesCount;
    private final Estimate dataSize;
    private final Optional<DoubleRange> range;

    public static ColumnStatistics empty() {
        return EMPTY;
    }

    public ColumnStatistics(Estimate nullsFraction, Estimate distinctValuesCount, Estimate dataSize, Optional<DoubleRange> range) {
        this.nullsFraction = Objects.requireNonNull(nullsFraction, "nullsFraction is null");
        if (!nullsFraction.isUnknown() && (nullsFraction.getValue() < 0.0 || nullsFraction.getValue() > 1.0)) {
            throw new IllegalArgumentException(String.format("nullsFraction must be between 0 and 1: %s", nullsFraction.getValue()));
        }
        this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
        if (!distinctValuesCount.isUnknown() && distinctValuesCount.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("distinctValuesCount must be greater than or equal to 0: %s", distinctValuesCount.getValue()));
        }
        this.dataSize = Objects.requireNonNull(dataSize, "dataSize is null");
        if (!dataSize.isUnknown() && dataSize.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("dataSize must be greater than or equal to 0: %s", dataSize.getValue()));
        }
        this.range = Objects.requireNonNull(range, "range is null");
    }

    public Estimate getNullsFraction() {
        return this.nullsFraction;
    }

    public Estimate getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public Estimate getDataSize() {
        return this.dataSize;
    }

    public Optional<DoubleRange> getRange() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return Objects.equals(this.nullsFraction, that.nullsFraction) && Objects.equals(this.distinctValuesCount, that.distinctValuesCount) && Objects.equals(this.dataSize, that.dataSize) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return Objects.hash(this.nullsFraction, this.distinctValuesCount, this.dataSize, this.range);
    }

    public String toString() {
        return "ColumnStatistics{nullsFraction=" + String.valueOf(this.nullsFraction) + ", distinctValuesCount=" + String.valueOf(this.distinctValuesCount) + ", dataSize=" + String.valueOf(this.dataSize) + ", range=" + String.valueOf(this.range) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate nullsFraction = Estimate.unknown();
        private Estimate distinctValuesCount = Estimate.unknown();
        private Estimate dataSize = Estimate.unknown();
        private Optional<DoubleRange> range = Optional.empty();

        public Builder setNullsFraction(Estimate nullsFraction) {
            this.nullsFraction = Objects.requireNonNull(nullsFraction, "nullsFraction is null");
            return this;
        }

        public Builder setDistinctValuesCount(Estimate distinctValuesCount) {
            this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
            return this;
        }

        public Builder setDataSize(Estimate dataSize) {
            this.dataSize = Objects.requireNonNull(dataSize, "dataSize is null");
            return this;
        }

        public Builder setRange(DoubleRange range) {
            this.range = Optional.of(Objects.requireNonNull(range, "range is null"));
            return this;
        }

        public Builder setRange(Optional<DoubleRange> range) {
            this.range = Objects.requireNonNull(range, "range is null");
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this.nullsFraction, this.distinctValuesCount, this.dataSize, this.range);
        }
    }
}

