/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import java.util.Map;
import java.util.Set;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.engine.cedrusdata.AbstractCatalogCedrusDataOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataRemoveOrphanFilesOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;
import ru.cedrusdata.catalog.spi.computeengine.result.Accumulator;
import ru.cedrusdata.catalog.spi.computeengine.result.CompositeComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.LongAccumulator;

public class CatalogCedrusDataRemoveOrphanFilesOperationFactory
extends AbstractCatalogCedrusDataOperationFactory {
    private final int olderThan;

    public CatalogCedrusDataRemoveOrphanFilesOperationFactory(Map<String, String> params, Jdbi jdbi, boolean resultReturnSupported) {
        super(jdbi, resultReturnSupported);
        CatalogComputeEngineOperationFactory.validateNoExtraParameters((String)"remove-orphan-files", params, Set.of("older-than"));
        this.olderThan = CatalogComputeEngineOperationFactory.parsePositiveIntegerParameter(params, (String)"older-than", (int)3);
    }

    public String name() {
        return "remove-orphan-files";
    }

    public CatalogComputeEngineOperation createTableOperation(CatalogTable table) {
        return new CatalogCedrusDataRemoveOrphanFilesOperation(this.jdbi, table, this.olderThan);
    }

    @Override
    public ComputeEngineResultAggregator doCreateResultAggregator() {
        return CompositeComputeEngineResultAggregator.newBuilder().add("deleted-files", (Accumulator)new LongAccumulator()).build();
    }
}

