/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import com.google.inject.CreationException;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.CedrusDataBootstrap;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataEngine;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataEngineConfig;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataEngineModule;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngine;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineProvider;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationParameterType;

public class CatalogCedrusDataEngineProvider
implements CatalogComputeEngineProvider {
    private final Map<Locale, ResourceBundle> labelBundles;

    public CatalogCedrusDataEngineProvider() {
        HashMap<Locale, ResourceBundle> labelBundles = new HashMap<Locale, ResourceBundle>();
        for (Locale locale : List.of(Locale.ENGLISH, Locale.forLanguageTag("ru"))) {
            labelBundles.put(locale, ResourceBundle.getBundle("i18n/CedrusDataEngineOperationMetadataBundle", locale));
        }
        this.labelBundles = Collections.unmodifiableMap(labelBundles);
    }

    public List<ComputeEngineOperationMetadata> supportedOperations() {
        ResourceBundle resourceBundle = this.labelBundles.get(Locale.ENGLISH);
        String engineType = CatalogComputeEngineType.CEDRUSDATA.name().toLowerCase(Locale.ROOT);
        return List.of(CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"expire-snapshots", Map.of("older-than", ComputeEngineOperationParameterType.INT)), CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"remove-orphan-files", Map.of("older-than", ComputeEngineOperationParameterType.INT)), CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"optimize", Map.of("file-size-threshold", ComputeEngineOperationParameterType.INT, "where", ComputeEngineOperationParameterType.STRING)), CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"drop-extended-stats", Map.of()), CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"refresh-materialized-view", Map.of()));
    }

    public Map<Locale, ResourceBundle> labels() {
        return this.labelBundles;
    }

    public CatalogComputeEngineType getComputeEngineType() {
        return CatalogComputeEngineType.CEDRUSDATA;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogComputeEngine createComputeEngine(CatalogPluginContext context, Map<String, String> config) {
        Optional<String> error = CatalogCedrusDataEngineConfig.validateProperties(config = config != null ? new HashMap<String, String>(config) : new HashMap(), context.resourceResolver());
        if (error.isPresent()) {
            throw (RuntimeException)context.configExceptionProvider().apply("Invalid properties: " + error.get());
        }
        ClassLoader classLoader = CatalogCedrusDataEngineProvider.class.getClassLoader();
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(classLoader);){
            CedrusDataBootstrap app = new CedrusDataBootstrap(new Module[]{new CatalogCedrusDataEngineModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).quiet().initialize();
            CatalogComputeEngine catalogComputeEngine = (CatalogComputeEngine)injector.getInstance(CatalogCedrusDataEngine.class);
            return catalogComputeEngine;
        }
        catch (CreationException e) {
            Iterator iterator = e.getErrorMessages().iterator();
            block7: while (true) {
                if (!iterator.hasNext()) throw e;
                Message message = (Message)iterator.next();
                Throwable cause = message.getCause();
                while (true) {
                    if (cause instanceof SQLException) {
                        throw (RuntimeException)context.configExceptionProvider().apply(cause.getMessage());
                    }
                    if (cause == null || cause == cause.getCause()) continue block7;
                    cause = cause.getCause();
                }
                break;
            }
        }
    }
}

