/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.result.ResultProducers;
import org.jdbi.v3.core.spi.JdbiPlugin;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataDropExtendedStatsOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataExpireSnapshotsOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataOptimizeOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataRefreshMaterializedViewOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataRemoveOrphanFilesOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngine;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class CatalogCedrusDataEngine
implements CatalogComputeEngine,
JdbiPlugin {
    private static final Logger log = Logger.get(CatalogCedrusDataEngine.class);
    private static final String RESULT_RETURN_PROPERTY = "cedrusdata_table_execute_result_enabled";
    private final DataSource dataSource;
    private final Jdbi jdbi;
    private volatile Boolean resultReturnSupported;

    @Inject
    public CatalogCedrusDataEngine(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbi = Jdbi.create((DataSource)dataSource);
        this.jdbi.installPlugin((JdbiPlugin)this);
        this.jdbi.configure(ResultProducers.class, config -> config.allowNoResults(true));
    }

    public Connection customizeConnection(Connection conn) throws SQLException {
        Boolean resultReturnSupported = this.resultReturnSupported;
        if (resultReturnSupported != null && resultReturnSupported.booleanValue()) {
            try (Statement statement = conn.createStatement();){
                statement.execute(String.format("SET SESSION %s=true", RESULT_RETURN_PROPERTY));
            }
        }
        return conn;
    }

    public CatalogComputeEngineOperationFactory createOperationFactory(String operationName, Map<String, String> operationParameters) {
        boolean resultReturnSupported = this.resultReturnSupported(this.jdbi);
        if ("expire-snapshots".equalsIgnoreCase(operationName)) {
            return new CatalogCedrusDataExpireSnapshotsOperationFactory(operationParameters, this.jdbi, resultReturnSupported);
        }
        if ("remove-orphan-files".equalsIgnoreCase(operationName)) {
            return new CatalogCedrusDataRemoveOrphanFilesOperationFactory(operationParameters, this.jdbi, resultReturnSupported);
        }
        if ("optimize".equalsIgnoreCase(operationName)) {
            return new CatalogCedrusDataOptimizeOperationFactory(operationParameters, this.jdbi, resultReturnSupported);
        }
        if ("drop-extended-stats".equalsIgnoreCase(operationName)) {
            return new CatalogCedrusDataDropExtendedStatsOperationFactory(operationParameters, this.jdbi, resultReturnSupported);
        }
        if ("refresh-materialized-view".equalsIgnoreCase(operationName)) {
            return new CatalogCedrusDataRefreshMaterializedViewOperationFactory(operationParameters, this.jdbi);
        }
        throw new CatalogBadRequestException(String.format("Unsupported operation: \"%s\"", operationName));
    }

    public Map<String, String> check() {
        Map<String, String> map;
        block8: {
            Handle handle = this.jdbi.open();
            try {
                map = Map.of("server-version", (String)handle.createQuery("SELECT version()").mapTo(String.class).one(), "jdbc-driver-version", handle.getConnection().getMetaData().getDriverVersion(), "maintenance-result-supported", Boolean.toString(this.resultReturnSupported(this.jdbi)));
                if (handle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            handle.close();
        }
        return map;
    }

    public void close() {
        DataSource dataSource = this.dataSource;
        if (dataSource instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)((Object)dataSource);
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resultReturnSupported(Jdbi jdbi) {
        Boolean resultReturnSupported = this.resultReturnSupported;
        if (resultReturnSupported == null) {
            CatalogCedrusDataEngine catalogCedrusDataEngine = this;
            synchronized (catalogCedrusDataEngine) {
                resultReturnSupported = this.resultReturnSupported;
                if (resultReturnSupported == null) {
                    try (Handle handle = jdbi.open();){
                        this.resultReturnSupported = resultReturnSupported = Boolean.valueOf(handle.createQuery(String.format("SHOW SESSION LIKE '%s'", RESULT_RETURN_PROPERTY)).mapToMap().findOne().isPresent());
                    }
                    catch (JdbiException e) {
                        log.warn((Throwable)e, "Failed to check whether result returning is supported");
                        return false;
                    }
                }
            }
        }
        return resultReturnSupported;
    }
}

