/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.switching;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.switching.SwitchingFileSystem;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class SwitchingFileSystemFactory
implements TrinoFileSystemFactory {
    private final Function<Location, TrinoFileSystemFactory> loader;

    public SwitchingFileSystemFactory(Function<Location, TrinoFileSystemFactory> loader) {
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    @Override
    public TrinoFileSystem create(ConnectorSession session) {
        return new SwitchingFileSystem(Optional.of(session), Optional.empty(), this.loader);
    }

    @Override
    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new SwitchingFileSystem(Optional.empty(), Optional.of(identity), this.loader);
    }
}

