/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.expression;

import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FieldDereference
extends ConnectorExpression {
    private final ConnectorExpression target;
    private final int field;

    public FieldDereference(Type type, ConnectorExpression target, int field) {
        super(type);
        this.target = Objects.requireNonNull(target, "target is null");
        this.field = field;
        int size = ((RowType)target.getType()).getFields().size();
        if (field < 0 || field >= size) {
            throw new IllegalArgumentException(String.format("field out of range: [0, %s], was %s", size - 1, field));
        }
    }

    public ConnectorExpression getTarget() {
        return this.target;
    }

    public int getField() {
        return this.field;
    }

    @Override
    public List<? extends ConnectorExpression> getChildren() {
        return Collections.singletonList(this.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, this.field, this.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDereference that = (FieldDereference)o;
        return Objects.equals(this.target, that.target) && this.field == that.field && Objects.equals(this.getType(), that.getType());
    }

    @Override
    public String toString() {
        return String.format("(%s).#%s", this.target, this.field);
    }
}

