/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;

enum SqsReceiveRequestAttributesGetter implements MessagingAttributesGetter<SqsReceiveRequest, Response>
{
    INSTANCE;


    public String getSystem(SqsReceiveRequest request) {
        return "AmazonSQS";
    }

    public String getDestination(SqsReceiveRequest request) {
        int i;
        SdkRequest sdkRequest = (SdkRequest)request.getRequest().getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        String queueUrl = SqsAccess.getQueueUrl(sdkRequest);
        if (queueUrl != null && (i = queueUrl.lastIndexOf(47)) > 0) {
            return queueUrl.substring(i + 1);
        }
        return null;
    }

    @Nullable
    public String getDestinationTemplate(SqsReceiveRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(SqsReceiveRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(SqsReceiveRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(SqsReceiveRequest request, @Nullable Response response) {
        return null;
    }

    @Nullable
    public String getClientId(SqsReceiveRequest request) {
        return null;
    }

    public Long getBatchMessageCount(SqsReceiveRequest request, @Nullable Response response) {
        return request.getMessages().size();
    }

    public List<String> getMessageHeader(SqsReceiveRequest request, String name) {
        return StreamSupport.stream(request.getMessages().spliterator(), false).map(message -> message.getMessageAttribute(name)).filter(value -> value != null).collect(Collectors.toList());
    }
}

