/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.airlift.log.Logger;
import io.trino.filesystem.s3.AwsSdkV2ApiCallStats;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;
import software.amazon.awssdk.core.internal.metrics.SdkErrorType;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.SdkMetric;

public class S3FileSystemStats {
    private final AwsSdkV2ApiCallStats total = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats headObject = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats getObject = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats listObjectsV2 = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats putObject = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats deleteObject = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats deleteObjects = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats createMultipartUpload = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats completeMultipartUpload = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats abortMultipartUpload = new AwsSdkV2ApiCallStats();
    private final AwsSdkV2ApiCallStats uploadPart = new AwsSdkV2ApiCallStats();
    private static final AwsSdkV2ApiCallStats dummy = new DummyAwsSdkV2ApiCallStats();

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getTotal() {
        return this.total;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getHeadObject() {
        return this.headObject;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getGetObject() {
        return this.getObject;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getListObjectsV2() {
        return this.listObjectsV2;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getPutObject() {
        return this.putObject;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getDeleteObject() {
        return this.deleteObject;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getDeleteObjects() {
        return this.deleteObjects;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getCreateMultipartUpload() {
        return this.createMultipartUpload;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getCompleteMultipartUpload() {
        return this.completeMultipartUpload;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats getAbortMultipartUpload() {
        return this.abortMultipartUpload;
    }

    @Managed
    @Nested
    public AwsSdkV2ApiCallStats uploadPart() {
        return this.uploadPart;
    }

    public MetricPublisher newMetricPublisher() {
        return new JmxMetricPublisher(this);
    }

    public static final class JmxMetricPublisher
    implements MetricPublisher {
        private static final Set<SdkMetric<?>> ALLOWED_METRICS = Set.of(CoreMetric.API_CALL_SUCCESSFUL, CoreMetric.RETRY_COUNT, CoreMetric.API_CALL_DURATION, CoreMetric.ERROR_TYPE);
        private static final Logger log = Logger.get(JmxMetricPublisher.class);
        private final S3FileSystemStats stats;

        public JmxMetricPublisher(S3FileSystemStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        public void publish(MetricCollection metricCollection) {
            try {
                Optional<String> serviceId = metricCollection.metricValues(CoreMetric.SERVICE_ID).stream().filter(Objects::nonNull).findFirst();
                Optional<String> operationName = metricCollection.metricValues(CoreMetric.OPERATION_NAME).stream().filter(Objects::nonNull).findFirst();
                if (serviceId.isEmpty() || operationName.isEmpty()) {
                    log.warn("ServiceId or OperationName is empty for AWS MetricCollection: %s", new Object[]{metricCollection});
                    return;
                }
                if (!serviceId.get().equals("S3")) {
                    return;
                }
                AwsSdkV2ApiCallStats apiCallStats = this.getApiCallStats(operationName.get());
                this.publishMetrics(metricCollection, apiCallStats);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Publishing AWS metrics failed");
            }
        }

        private void publishMetrics(MetricCollection metricCollection, AwsSdkV2ApiCallStats apiCallStats) {
            metricCollection.stream().filter(metricRecord -> metricRecord.value() != null && ALLOWED_METRICS.contains(metricRecord.metric())).forEach(metricRecord -> {
                if (metricRecord.metric().equals((Object)CoreMetric.API_CALL_SUCCESSFUL)) {
                    Boolean value = (Boolean)metricRecord.value();
                    this.stats.total.updateCalls();
                    apiCallStats.updateCalls();
                    if (value.equals(Boolean.FALSE)) {
                        this.stats.total.updateFailures();
                        apiCallStats.updateFailures();
                    }
                } else if (metricRecord.metric().equals((Object)CoreMetric.RETRY_COUNT)) {
                    int value = (Integer)metricRecord.value();
                    this.stats.total.updateRetries(value);
                    apiCallStats.updateRetries(value);
                } else if (metricRecord.metric().equals((Object)CoreMetric.API_CALL_DURATION)) {
                    Duration value = (Duration)metricRecord.value();
                    this.stats.total.updateLatency(value);
                    apiCallStats.updateLatency(value);
                } else if (metricRecord.metric().equals((Object)CoreMetric.ERROR_TYPE)) {
                    String value = (String)metricRecord.value();
                    if (value.equals(SdkErrorType.THROTTLING.toString())) {
                        this.stats.total.updateThrottlingExceptions();
                        apiCallStats.updateThrottlingExceptions();
                    } else if (value.equals(SdkErrorType.SERVER_ERROR.toString())) {
                        this.stats.total.updateServerErrors();
                        apiCallStats.updateServerErrors();
                    }
                }
            });
            metricCollection.children().forEach(child -> this.publishMetrics((MetricCollection)child, apiCallStats));
        }

        public void close() {
        }

        private AwsSdkV2ApiCallStats getApiCallStats(String operationName) {
            return switch (operationName) {
                case "HeadObject" -> this.stats.headObject;
                case "GetObject" -> this.stats.getObject;
                case "ListObjectsV2" -> this.stats.listObjectsV2;
                case "PutObject" -> this.stats.putObject;
                case "DeleteObject" -> this.stats.deleteObject;
                case "DeleteObjects" -> this.stats.deleteObjects;
                case "CreateMultipartUpload" -> this.stats.createMultipartUpload;
                case "CompleteMultipartUpload" -> this.stats.completeMultipartUpload;
                case "AbortMultipartUpload" -> this.stats.abortMultipartUpload;
                case "UploadPart" -> this.stats.uploadPart;
                default -> dummy;
            };
        }
    }

    private static class DummyAwsSdkV2ApiCallStats
    extends AwsSdkV2ApiCallStats {
        private DummyAwsSdkV2ApiCallStats() {
        }

        @Override
        public void updateLatency(Duration duration) {
        }

        @Override
        public void updateCalls() {
        }

        @Override
        public void updateFailures() {
        }

        @Override
        public void updateRetries(int retryCount) {
        }

        @Override
        public void updateThrottlingExceptions() {
        }

        @Override
        public void updateServerErrors() {
        }
    }
}

