/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class HadoopKerberosName
extends KerberosName {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopKerberosName.class);

    public HadoopKerberosName(String name) {
        super(name);
    }

    public static void setConfiguration(Configuration conf) throws IOException {
        String defaultRule;
        switch (SecurityUtil.getAuthenticationMethod(conf)) {
            case KERBEROS: 
            case KERBEROS_SSL: {
                try {
                    KerberosUtil.getDefaultRealm();
                }
                catch (Exception ke) {
                    throw new IllegalArgumentException("Can't get Kerberos realm", ke);
                }
                defaultRule = "DEFAULT";
                break;
            }
            default: {
                defaultRule = "RULE:[1:$1] RULE:[2:$1]";
            }
        }
        String ruleString = conf.get("hadoop.security.auth_to_local", defaultRule);
        HadoopKerberosName.setRules(ruleString);
        String ruleMechanism = conf.get("hadoop.security.auth_to_local.mechanism", "hadoop");
        HadoopKerberosName.setRuleMechanism(ruleMechanism);
    }

    public static void main(String[] args) throws Exception {
        HadoopKerberosName.setConfiguration(new Configuration());
        for (String arg : args) {
            HadoopKerberosName name = new HadoopKerberosName(arg);
            System.out.println("Name: " + name + " to " + name.getShortName());
        }
    }
}

