/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.trino.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailed;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFailedEvent
implements HistoryEvent {
    private TaskFailed datum = null;
    private TaskAttemptID failedDueToAttempt;
    private TaskID id;
    private TaskType taskType;
    private long finishTime;
    private String status;
    private String error;
    private Counters counters;
    private long startTime;
    private static final Counters EMPTY_COUNTERS = new Counters();

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt, Counters counters, long startTs) {
        this.id = id;
        this.finishTime = finishTime;
        this.taskType = taskType;
        this.error = error;
        this.status = status;
        this.failedDueToAttempt = failedDueToAttempt;
        this.counters = counters;
        this.startTime = startTs;
    }

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt, Counters counters) {
        this(id, finishTime, taskType, error, status, failedDueToAttempt, counters, SystemClock.getInstance().getTime());
    }

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt) {
        this(id, finishTime, taskType, error, status, failedDueToAttempt, EMPTY_COUNTERS);
    }

    TaskFailedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskFailed();
            this.datum.setTaskid(new Utf8(this.id.toString()));
            this.datum.setError(new Utf8(this.error));
            this.datum.setFinishTime(this.finishTime);
            this.datum.setTaskType(new Utf8(this.taskType.name()));
            this.datum.setFailedDueToAttempt(this.failedDueToAttempt == null ? null : new Utf8(this.failedDueToAttempt.toString()));
            this.datum.setStatus(new Utf8(this.status));
            this.datum.setCounters(EventWriter.toAvro(this.counters));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object odatum) {
        this.datum = (TaskFailed)odatum;
        this.id = TaskID.forName(this.datum.getTaskid().toString());
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.finishTime = this.datum.getFinishTime();
        this.error = this.datum.getError().toString();
        this.failedDueToAttempt = this.datum.getFailedDueToAttempt() == null ? null : TaskAttemptID.forName(this.datum.getFailedDueToAttempt().toString());
        this.status = this.datum.getStatus().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
    }

    public TaskID getTaskId() {
        return this.id;
    }

    public String getError() {
        return this.error;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public TaskAttemptID getFailedAttemptID() {
        return this.failedDueToAttempt;
    }

    public String getTaskStatus() {
        return this.status;
    }

    public Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FAILED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", (Object)this.getTaskType().toString());
        tEvent.addInfo("STATUS", (Object)TaskStatus.State.FAILED.toString());
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("ERROR", (Object)this.getError());
        tEvent.addInfo("FAILED_ATTEMPT_ID", (Object)(this.getFailedAttemptID() == null ? "" : this.getFailedAttemptID().toString()));
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> metrics = JobHistoryEventUtils.countersToTimelineMetric(this.getCounters(), this.finishTime);
        return metrics;
    }
}

