/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FileSystemConfigurations;
import org.apache.hadoop.fs.azurebfs.contracts.annotations.ConfigurationValidationAnnotations;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConfigurationPropertyNotFoundException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.diagnostics.Base64StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.BooleanConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.IntegerConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.LongConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.UserPasswordTokenProvider;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.KeyProvider;
import org.apache.hadoop.fs.azurebfs.services.SimpleKeyProvider;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AbfsConfiguration {
    private final Configuration rawConfig;
    private final String accountName;
    private final boolean isSecure;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsConfiguration.class);
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.hns.enabled", DefaultValue="")
    private String isNamespaceEnabledAccount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.max.concurrent.requests", DefaultValue=-1)
    private int writeMaxConcurrentRequestCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.max.requests.to.queue", DefaultValue=-1)
    private int maxWriteRequestsToQueue;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x800000)
    private int writeBufferSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.enableappendwithflush", DefaultValue=false)
    private boolean enableSmallWriteOptimization;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.smallfilescompletely", DefaultValue=false)
    private boolean readSmallFilesCompletely;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.optimizefooterread", DefaultValue=false)
    private boolean optimizeFooterRead;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.throttling.enabled", DefaultValue=true)
    private boolean accountThrottlingEnabled;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x400000)
    private int readBufferSize;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.readahead.range", MinValue=16384, MaxValue=0x6400000, DefaultValue=65536)
    private int readAheadRange;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.min.backoff.interval", DefaultValue=3000)
    private int minBackoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.backoff.interval", DefaultValue=30000)
    private int maxBackoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.backoff.interval", DefaultValue=3000)
    private int backoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.retries", MinValue=0, DefaultValue=30)
    private int maxIoRetries;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.custom.token.fetch.retry.count", MinValue=0, DefaultValue=3)
    private int customTokenFetchRetryCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.max.retries", MinValue=0, DefaultValue=5)
    private int oauthTokenFetchRetryCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.min.backoff.interval", MinValue=0, DefaultValue=0)
    private int oauthTokenFetchRetryMinBackoff;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.max.backoff.interval", MinValue=0, DefaultValue=60000)
    private int oauthTokenFetchRetryMaxBackoff;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.delta.backoff", MinValue=0, DefaultValue=2)
    private int oauthTokenFetchRetryDeltaBackoff;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.size", MinValue=0L, MaxValue=0x10000000L, DefaultValue=0x10000000L)
    private long azureBlockSize;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.location.impersonatedhost", DefaultValue="localhost")
    private String azureBlockLocationHost;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.out", MinValue=1, DefaultValue=8)
    private int maxConcurrentWriteThreads;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.list.max.results", MinValue=1, DefaultValue=5000)
    private int listMaxResults;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.in", MinValue=1, DefaultValue=12)
    private int maxConcurrentReadThreads;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.read.tolerate.concurrent.append", DefaultValue=false)
    private boolean tolerateOobAppends;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.atomic.rename.key", DefaultValue="/hbase")
    private String azureAtomicDirs;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.conditional.create.overwrite", DefaultValue=true)
    private boolean enableConditionalCreateOverwrite;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.mkdir.overwrite", DefaultValue=true)
    private boolean mkdirOverwrite;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.appendblob.directories", DefaultValue="")
    private String azureAppendBlobDirs;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.infinite-lease.directories", DefaultValue="")
    private String azureInfiniteLeaseDirs;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.lease.threads", MinValue=0, DefaultValue=0)
    private int numLeaseThreads;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.createRemoteFileSystemDuringInitialization", DefaultValue=false)
    private boolean createRemoteFileSystemDuringInitialization;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.skipUserGroupMetadataDuringInitialization", DefaultValue=false)
    private boolean skipUserGroupMetadataDuringInitialization;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.readaheadqueue.depth", DefaultValue=2)
    private int readAheadQueueDepth;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.readahead.blocksize", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x400000)
    private int readAheadBlockSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.alwaysReadBufferSize", DefaultValue=false)
    private boolean alwaysReadBufferSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.flush", DefaultValue=true)
    private boolean enableFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.disable.outputstream.flush", DefaultValue=true)
    private boolean disableOutputStreamFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.autothrottling", DefaultValue=true)
    private boolean enableAutoThrottling;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.operation.idle.timeout", DefaultValue=60000)
    private int accountOperationIdleTimeout;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.analysis.period", DefaultValue=10000)
    private int analysisPeriod;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.rate.limit", MinValue=0, DefaultValue=10000)
    private int rateLimit;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.user.agent.prefix", DefaultValue="")
    private String userAgentId;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.cluster.name", DefaultValue="UNKNOWN")
    private String clusterName;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.cluster.type", DefaultValue="UNKNOWN")
    private String clusterType;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.client.correlationid", DefaultValue="")
    private String clientCorrelationId;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.delegation.token", DefaultValue=false)
    private boolean enableDelegationToken;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.always.use.https", DefaultValue=true)
    private boolean alwaysUseHttps;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.use.upn", DefaultValue=false)
    private boolean useUpn;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.check.access", DefaultValue=true)
    private boolean isCheckAccessEnabled;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.abfs.latency.track", DefaultValue=false)
    private boolean trackLatency;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.readahead", DefaultValue=true)
    private boolean enabledReadAhead;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.sas.token.renew.period.for.streams", MinValue=0L, DefaultValue=120L)
    private long sasTokenRenewPeriodForStreamsInSeconds;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.abfslistiterator", DefaultValue=true)
    private boolean enableAbfsListIterator;

    public AbfsConfiguration(Configuration rawConfig, String accountName) throws IllegalAccessException, InvalidConfigurationValueException, IOException {
        Field[] fields;
        this.rawConfig = ProviderUtils.excludeIncompatibleCredentialProviders(rawConfig, AzureBlobFileSystem.class);
        this.accountName = accountName;
        this.isSecure = this.getBoolean("fs.azure.secure.mode", false);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateInt(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateIntWithOutlier(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateLong(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateString(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateBase64String(field));
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class)) continue;
            field.set(this, this.validateBoolean(field));
        }
    }

    public Trilean getIsNamespaceEnabledAccount() {
        return Trilean.getTrilean(this.isNamespaceEnabledAccount);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    public String accountConf(String key) {
        return key + "." + this.accountName;
    }

    public String get(String key) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key));
    }

    public String getString(String key, String defaultValue) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key, defaultValue));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.rawConfig.getBoolean(this.accountConf(key), this.rawConfig.getBoolean(key, defaultValue));
    }

    public long getLong(String key, long defaultValue) {
        return this.rawConfig.getLong(this.accountConf(key), this.rawConfig.getLong(key, defaultValue));
    }

    public String getPasswordString(String key) throws IOException {
        char[] passchars = this.rawConfig.getPassword(this.accountConf(key));
        if (passchars == null) {
            passchars = this.rawConfig.getPassword(key);
        }
        if (passchars != null) {
            return new String(passchars);
        }
        return null;
    }

    private String getMandatoryPasswordString(String key) throws IOException {
        String value = this.getPasswordString(key);
        if (value == null) {
            throw new ConfigurationPropertyNotFoundException(key);
        }
        return value;
    }

    public <U> Class<? extends U> getTokenProviderClass(AuthType authType, String name, Class<? extends U> defaultValue, Class<U> xface) {
        Class<U> tokenProviderClass = this.getAccountSpecificClass(name, defaultValue, xface);
        if (tokenProviderClass == null && authType == this.getAccountAgnosticEnum("fs.azure.account.auth.type", AuthType.SharedKey)) {
            tokenProviderClass = this.getAccountAgnosticClass(name, defaultValue, xface);
        }
        return tokenProviderClass == null ? null : tokenProviderClass.asSubclass(xface);
    }

    public <U> Class<? extends U> getAccountSpecificClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.rawConfig.getClass(this.accountConf(name), defaultValue, xface);
    }

    public <U> Class<? extends U> getAccountAgnosticClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.rawConfig.getClass(name, defaultValue, xface);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        return this.rawConfig.getEnum(this.accountConf(name), this.rawConfig.getEnum(name, defaultValue));
    }

    public <T extends Enum<T>> T getAccountAgnosticEnum(String name, T defaultValue) {
        return this.rawConfig.getEnum(name, defaultValue);
    }

    public void unset(String key) {
        this.rawConfig.unset(key);
    }

    public void set(String key, String value) {
        this.rawConfig.set(key, value);
    }

    public void setBoolean(String key, boolean value) {
        this.rawConfig.setBoolean(key, value);
    }

    public boolean isSecureMode() {
        return this.isSecure;
    }

    public String getStorageAccountKey() throws AzureBlobFileSystemException {
        KeyProvider keyProvider;
        String keyProviderClass = this.get("fs.azure.account.keyprovider");
        if (keyProviderClass == null) {
            keyProvider = new SimpleKeyProvider();
        } else {
            Object keyProviderObject;
            try {
                Class<?> clazz = this.rawConfig.getClassByName(keyProviderClass);
                keyProviderObject = clazz.newInstance();
            }
            catch (Exception e) {
                throw new KeyProviderException("Unable to load key provider class.", (Throwable)e);
            }
            if (!(keyProviderObject instanceof KeyProvider)) {
                throw new KeyProviderException(keyProviderClass + " specified in config is not a valid KeyProvider class.");
            }
            keyProvider = (KeyProvider)keyProviderObject;
        }
        String key = keyProvider.getStorageAccountKey(this.accountName, this.rawConfig);
        if (key == null) {
            throw new ConfigurationPropertyNotFoundException(this.accountName);
        }
        return key;
    }

    public Configuration getRawConfiguration() {
        return this.rawConfig;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean isSmallWriteOptimizationEnabled() {
        return this.enableSmallWriteOptimization;
    }

    public boolean readSmallFilesCompletely() {
        return this.readSmallFilesCompletely;
    }

    public boolean optimizeFooterRead() {
        return this.optimizeFooterRead;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMinBackoffIntervalMilliseconds() {
        return this.minBackoffInterval;
    }

    public int getMaxBackoffIntervalMilliseconds() {
        return this.maxBackoffInterval;
    }

    public int getBackoffIntervalMilliseconds() {
        return this.backoffInterval;
    }

    public int getMaxIoRetries() {
        return this.maxIoRetries;
    }

    public int getCustomTokenFetchRetryCount() {
        return this.customTokenFetchRetryCount;
    }

    public long getAzureBlockSize() {
        return this.azureBlockSize;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public long getSasTokenRenewPeriodForStreamsInSeconds() {
        return this.sasTokenRenewPeriodForStreamsInSeconds;
    }

    public String getAzureBlockLocationHost() {
        return this.azureBlockLocationHost;
    }

    public int getMaxConcurrentWriteThreads() {
        return this.maxConcurrentWriteThreads;
    }

    public int getMaxConcurrentReadThreads() {
        return this.maxConcurrentReadThreads;
    }

    public int getListMaxResults() {
        return this.listMaxResults;
    }

    public boolean getTolerateOobAppends() {
        return this.tolerateOobAppends;
    }

    public String getAzureAtomicRenameDirs() {
        return this.azureAtomicDirs;
    }

    public boolean isConditionalCreateOverwriteEnabled() {
        return this.enableConditionalCreateOverwrite;
    }

    public boolean isEnabledMkdirOverwrite() {
        return this.mkdirOverwrite;
    }

    public String getAppendBlobDirs() {
        return this.azureAppendBlobDirs;
    }

    public boolean accountThrottlingEnabled() {
        return this.accountThrottlingEnabled;
    }

    public String getAzureInfiniteLeaseDirs() {
        return this.azureInfiniteLeaseDirs;
    }

    public int getNumLeaseThreads() {
        return this.numLeaseThreads;
    }

    public boolean getCreateRemoteFileSystemDuringInitialization() {
        return this.createRemoteFileSystemDuringInitialization && this.getAuthType(this.accountName) != AuthType.SAS;
    }

    public boolean getSkipUserGroupMetadataDuringInitialization() {
        return this.skipUserGroupMetadataDuringInitialization;
    }

    public int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public int getReadAheadBlockSize() {
        return this.readAheadBlockSize;
    }

    public boolean shouldReadBufferSizeAlways() {
        return this.alwaysReadBufferSize;
    }

    public boolean isFlushEnabled() {
        return this.enableFlush;
    }

    public boolean isOutputStreamFlushDisabled() {
        return this.disableOutputStreamFlush;
    }

    public boolean isAutoThrottlingEnabled() {
        return this.enableAutoThrottling;
    }

    public int getAccountOperationIdleTimeout() {
        return this.accountOperationIdleTimeout;
    }

    public int getAnalysisPeriod() {
        return this.analysisPeriod;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public String getCustomUserAgentPrefix() {
        return this.userAgentId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public DelegatingSSLSocketFactory.SSLChannelMode getPreferredSSLFactoryOption() {
        return this.getEnum("fs.azure.ssl.channel.mode", FileSystemConfigurations.DEFAULT_FS_AZURE_SSL_CHANNEL_MODE);
    }

    public TracingHeaderFormat getTracingHeaderFormat() {
        return this.getEnum("fs.azure.tracingheader.format", TracingHeaderFormat.ALL_ID_FORMAT);
    }

    public AuthType getAuthType(String accountName) {
        return this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
    }

    public boolean isDelegationTokenManagerEnabled() {
        return this.enableDelegationToken;
    }

    public AbfsDelegationTokenManager getDelegationTokenManager() throws IOException {
        return new AbfsDelegationTokenManager(this.getRawConfiguration());
    }

    public boolean isHttpsAlwaysUsed() {
        return this.alwaysUseHttps;
    }

    public boolean isUpnUsed() {
        return this.useUpn;
    }

    public boolean shouldTrackLatency() {
        return this.trackLatency;
    }

    public AccessTokenProvider getTokenProvider() throws TokenAccessProviderException {
        AuthType authType = this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        if (authType == AuthType.OAuth) {
            try {
                AccessTokenProvider tokenProvider;
                Class<AccessTokenProvider> tokenProviderClass = this.getTokenProviderClass(authType, "fs.azure.account.oauth.provider.type", null, AccessTokenProvider.class);
                if (tokenProviderClass == ClientCredsTokenProvider.class) {
                    String authEndpoint = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    String clientSecret = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.secret");
                    tokenProvider = new ClientCredsTokenProvider(authEndpoint, clientId, clientSecret);
                    LOG.trace("ClientCredsTokenProvider initialized");
                } else if (tokenProviderClass == UserPasswordTokenProvider.class) {
                    String authEndpoint = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String username = this.getMandatoryPasswordString("fs.azure.account.oauth2.user.name");
                    String password = this.getMandatoryPasswordString("fs.azure.account.oauth2.user.password");
                    tokenProvider = new UserPasswordTokenProvider(authEndpoint, username, password);
                    LOG.trace("UserPasswordTokenProvider initialized");
                } else if (tokenProviderClass == MsiTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.endpoint", "http://169.254.169.254/metadata/identity/oauth2/token");
                    String tenantGuid = this.getMandatoryPasswordString("fs.azure.account.oauth2.msi.tenant");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    String authority = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/");
                    authority = this.appendSlashIfNeeded(authority);
                    tokenProvider = new MsiTokenProvider(authEndpoint, tenantGuid, clientId, authority);
                    LOG.trace("MsiTokenProvider initialized");
                } else if (tokenProviderClass == RefreshTokenBasedTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.refresh.token.endpoint", "https://login.microsoftonline.com/Common/oauth2/token");
                    String refreshToken = this.getMandatoryPasswordString("fs.azure.account.oauth2.refresh.token");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    tokenProvider = new RefreshTokenBasedTokenProvider(authEndpoint, clientId, refreshToken);
                    LOG.trace("RefreshTokenBasedTokenProvider initialized");
                } else {
                    throw new IllegalArgumentException("Failed to initialize " + tokenProviderClass);
                }
                return tokenProvider;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load OAuth token provider class.", (Throwable)e);
            }
        }
        if (authType == AuthType.Custom) {
            try {
                String configKey = "fs.azure.account.oauth.provider.type";
                Class<CustomTokenProviderAdaptee> customTokenProviderClass = this.getTokenProviderClass(authType, configKey, null, CustomTokenProviderAdaptee.class);
                if (customTokenProviderClass == null) {
                    throw new IllegalArgumentException(String.format("The configuration value for \"%s\" is invalid.", configKey));
                }
                CustomTokenProviderAdaptee azureTokenProvider = ReflectionUtils.newInstance(customTokenProviderClass, this.rawConfig);
                if (azureTokenProvider == null) {
                    throw new IllegalArgumentException("Failed to initialize " + customTokenProviderClass);
                }
                LOG.trace("Initializing {}", (Object)customTokenProviderClass.getName());
                azureTokenProvider.initialize(this.rawConfig, this.accountName);
                LOG.trace("{} init complete", (Object)customTokenProviderClass.getName());
                return new CustomTokenProviderAdapter(azureTokenProvider, this.getCustomTokenFetchRetryCount());
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load custom token provider class: " + e, (Throwable)e);
            }
        }
        throw new TokenAccessProviderException(String.format("Invalid auth type: %s is being used, expecting OAuth", new Object[]{authType}));
    }

    public SASTokenProvider getSASTokenProvider() throws AzureBlobFileSystemException {
        AuthType authType = this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        if (authType != AuthType.SAS) {
            throw new SASTokenProviderException(String.format("Invalid auth type: %s is being used, expecting SAS", new Object[]{authType}));
        }
        try {
            String configKey = "fs.azure.sas.token.provider.type";
            Class<SASTokenProvider> sasTokenProviderClass = this.getTokenProviderClass(authType, configKey, null, SASTokenProvider.class);
            Preconditions.checkArgument(sasTokenProviderClass != null, String.format("The configuration value for \"%s\" is invalid.", configKey));
            SASTokenProvider sasTokenProvider = ReflectionUtils.newInstance(sasTokenProviderClass, this.rawConfig);
            Preconditions.checkArgument(sasTokenProvider != null, String.format("Failed to initialize %s", sasTokenProviderClass));
            LOG.trace("Initializing {}", (Object)sasTokenProviderClass.getName());
            sasTokenProvider.initialize(this.rawConfig, this.accountName);
            LOG.trace("{} init complete", (Object)sasTokenProviderClass.getName());
            return sasTokenProvider;
        }
        catch (Exception e) {
            throw new TokenAccessProviderException("Unable to load SAS token provider class: " + e, (Throwable)e);
        }
    }

    public boolean isReadAheadEnabled() {
        return this.enabledReadAhead;
    }

    @VisibleForTesting
    void setReadAheadEnabled(boolean enabledReadAhead) {
        this.enabledReadAhead = enabledReadAhead;
    }

    public int getReadAheadRange() {
        return this.readAheadRange;
    }

    int validateInt(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class);
        String value = this.get(validator.ConfigurationKey());
        return new IntegerConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    int validateIntWithOutlier(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation.class);
        String value = this.get(validator.ConfigurationKey());
        return new IntegerConfigurationBasicValidator(validator.OutlierValue(), validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    long validateLong(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new LongConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateString(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateBase64String(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new Base64StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    boolean validateBoolean(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new BooleanConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    public ExponentialRetryPolicy getOauthTokenFetchRetryPolicy() {
        return new ExponentialRetryPolicy(this.oauthTokenFetchRetryCount, this.oauthTokenFetchRetryMinBackoff, this.oauthTokenFetchRetryMaxBackoff, this.oauthTokenFetchRetryDeltaBackoff);
    }

    public int getWriteMaxConcurrentRequestCount() {
        if (this.writeMaxConcurrentRequestCount < 1) {
            return 4 * Runtime.getRuntime().availableProcessors();
        }
        return this.writeMaxConcurrentRequestCount;
    }

    public int getMaxWriteRequestsToQueue() {
        if (this.maxWriteRequestsToQueue < 1) {
            return 2 * this.getWriteMaxConcurrentRequestCount();
        }
        return this.maxWriteRequestsToQueue;
    }

    public boolean enableAbfsListIterator() {
        return this.enableAbfsListIterator;
    }

    public String getClientProvidedEncryptionKey() {
        String accSpecEncKey = this.accountConf("fs.azure.client-provided-encryption-key");
        return this.rawConfig.get(accSpecEncKey, null);
    }

    @VisibleForTesting
    void setReadBufferSize(int bufferSize) {
        this.readBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setWriteBufferSize(int bufferSize) {
        this.writeBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setEnableFlush(boolean enableFlush) {
        this.enableFlush = enableFlush;
    }

    @VisibleForTesting
    void setDisableOutputStreamFlush(boolean disableOutputStreamFlush) {
        this.disableOutputStreamFlush = disableOutputStreamFlush;
    }

    @VisibleForTesting
    void setListMaxResults(int listMaxResults) {
        this.listMaxResults = listMaxResults;
    }

    @VisibleForTesting
    public void setMaxIoRetries(int maxIoRetries) {
        this.maxIoRetries = maxIoRetries;
    }

    @VisibleForTesting
    void setMaxBackoffIntervalMilliseconds(int maxBackoffInterval) {
        this.maxBackoffInterval = maxBackoffInterval;
    }

    @VisibleForTesting
    void setIsNamespaceEnabledAccount(String isNamespaceEnabledAccount) {
        this.isNamespaceEnabledAccount = isNamespaceEnabledAccount;
    }

    private String getTrimmedPasswordString(String key, String defaultValue) throws IOException {
        String value = this.getPasswordString(key);
        if (StringUtils.isBlank(value)) {
            value = defaultValue;
        }
        return value.trim();
    }

    private String appendSlashIfNeeded(String authority) {
        if (!authority.endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }

    @VisibleForTesting
    public void setReadSmallFilesCompletely(boolean readSmallFilesCompletely) {
        this.readSmallFilesCompletely = readSmallFilesCompletely;
    }

    @VisibleForTesting
    public void setOptimizeFooterRead(boolean optimizeFooterRead) {
        this.optimizeFooterRead = optimizeFooterRead;
    }

    @VisibleForTesting
    public void setEnableAbfsListIterator(boolean enableAbfsListIterator) {
        this.enableAbfsListIterator = enableAbfsListIterator;
    }
}

