/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.ConfigRedactor;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class ConfigurationWithLogging
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationWithLogging.class);
    private final Logger log = LOG;
    private final ConfigRedactor redactor;

    public ConfigurationWithLogging(Configuration conf) {
        super(conf);
        this.redactor = new ConfigRedactor(conf);
    }

    @Override
    public String get(String name) {
        String value = super.get(name);
        this.log.info("Got {} = '{}'", (Object)name, (Object)this.redactor.redact(name, value));
        return value;
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = super.get(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", name, this.redactor.redact(name, value), this.redactor.redact(name, defaultValue));
        return value;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        boolean value = super.getBoolean(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", name, value, defaultValue);
        return value;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        float value = super.getFloat(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", name, Float.valueOf(value), Float.valueOf(defaultValue));
        return value;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        int value = super.getInt(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", name, value, defaultValue);
        return value;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        long value = super.getLong(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", name, value, defaultValue);
        return value;
    }

    @Override
    public void set(String name, String value, String source) {
        this.log.info("Set {} to '{}'{}", name, this.redactor.redact(name, value), source == null ? "" : " from " + source);
        super.set(name, value, source);
    }
}

