/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop;

import com.google.common.reflect.Reflection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.io.compress.zstd.ZStandardCompressor;
import org.apache.hadoop.io.compress.zstd.ZStandardDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public final class HadoopNative {
    private static boolean loaded = false;
    private static Throwable error = null;

    private HadoopNative() {
    }

    public static synchronized void requireHadoopNative() {
        if (loaded) {
            return;
        }
        if (error != null) {
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
        try {
            Reflection.initialize((Class[])new Class[]{ZStandardCompressor.class});
            Reflection.initialize((Class[])new Class[]{ZStandardDecompressor.class});
            HadoopNative.loadLibrary("hadoop");
            NativeCodeLoader.setNativeCodeLoaded();
            loaded = true;
        }
        catch (Throwable t) {
            error = t;
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
    }

    private static void loadLibrary(String name) throws IOException {
        String libraryPath = HadoopNative.getLibraryPath(name);
        URL url = HadoopNative.class.getResource(libraryPath);
        if (url == null) {
            throw new RuntimeException("library not found: " + libraryPath);
        }
        File file = File.createTempFile(name, null);
        file.deleteOnExit();
        try (InputStream in = url.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(file.getAbsolutePath());
    }

    private static String getLibraryPath(String name) {
        return "/nativelib/" + HadoopNative.getPlatform() + "/" + System.mapLibraryName(name);
    }

    private static String getPlatform() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return (name + "-" + arch).replace(' ', '_');
    }
}

