/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2;

import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Date;

public abstract class AccessTokenProvider {
    protected AzureADToken token;
    private static final Logger log = LoggerFactory.getLogger("io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider");
    private static final long FIVE_MINUTES = 300000L;

    public synchronized AzureADToken getToken() throws IOException {
        if (this.isTokenAboutToExpire()) {
            log.debug("AAD Token is missing or expired: Calling refresh-token from abstract base class");
            this.token = this.refreshToken();
        }
        return this.token;
    }

    protected abstract AzureADToken refreshToken() throws IOException;

    protected boolean isTokenAboutToExpire() {
        boolean expiring;
        if (this.token == null) {
            log.debug("AADToken: no token. Returning expiring=true");
            return true;
        }
        if (this.token.expiry == null) {
            log.debug("AADToken: no token expiry set. Returning expiring=true");
            return true;
        }
        long offset = 300000L;
        long approximatelyNow = System.currentTimeMillis() + offset;
        boolean bl = expiring = this.token.expiry.getTime() < approximatelyNow;
        if (expiring) {
            log.debug("AADToken: token expiring: " + this.token.expiry.toString() + " : " + offset + " milliseconds window: " + new Date(approximatelyNow).toString());
        }
        return expiring;
    }
}

