/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.layouters;

import java.util.TreeSet;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.Layouter;

public class RawLayouter
implements Layouter {
    private final DataModel model;

    public RawLayouter(DataModel model) {
        this.model = model;
    }

    @Override
    public ClassLayout layout(ClassData data) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (data.isArray()) {
            int base = 0;
            int scale = this.model.sizeOf(data.arrayComponentType());
            long instanceSize = (long)base + data.arrayLength() * (long)scale;
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, (long)scale * data.arrayLength()));
            return ClassLayout.create(data, result, this.model, instanceSize, false);
        }
        int offset = 0;
        for (FieldData f : data.fields()) {
            int size = this.model.sizeOf(f.typeClass());
            result.add(new FieldLayout(f, offset, size));
            offset += size;
        }
        if (result.isEmpty()) {
            return ClassLayout.create(data, result, this.model, 0L, false);
        }
        FieldLayout f = (FieldLayout)result.last();
        return ClassLayout.create(data, result, this.model, f.offset() + f.size(), false);
    }

    public String toString() {
        return "Raw data (" + this.model + ")";
    }
}

