/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Timeout;

class TracingCallFactory
implements Call.Factory {
    private static final VirtualField<Request, Context> contextsByRequest = VirtualField.find(Request.class, Context.class);
    @Nullable
    private static Method timeoutMethod;
    @Nullable
    private static Method cloneMethod;
    private final OkHttpClient okHttpClient;

    TracingCallFactory(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Nullable
    static Context getCallingContextForRequest(Request request) {
        return (Context)contextsByRequest.get((Object)request);
    }

    public Call newCall(Request request) {
        Context callingContext = Context.current();
        Request requestCopy = request.newBuilder().build();
        contextsByRequest.set((Object)requestCopy, (Object)callingContext);
        return new TracingCall(this.okHttpClient.newCall(requestCopy), callingContext);
    }

    static {
        try {
            timeoutMethod = Call.class.getMethod("timeout", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            timeoutMethod = null;
        }
        try {
            cloneMethod = Call.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            cloneMethod = null;
        }
    }

    static class TracingCall
    implements Call {
        private final Call delegate;
        private final Context callingContext;

        TracingCall(Call delegate, Context callingContext) {
            this.delegate = delegate;
            this.callingContext = callingContext;
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public Call clone() throws CloneNotSupportedException {
            if (cloneMethod == null) {
                return (Call)super.clone();
            }
            try {
                return new TracingCall((Call)cloneMethod.invoke((Object)this.delegate, new Object[0]), Context.current());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return (Call)super.clone();
            }
        }

        public void enqueue(Callback callback) {
            this.delegate.enqueue((Callback)new TracingCallback(callback, this.callingContext));
        }

        public Response execute() throws IOException {
            try (Scope scope = this.callingContext.makeCurrent();){
                Response response = this.delegate.execute();
                return response;
            }
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        public Request request() {
            return this.delegate.request();
        }

        public Timeout timeout() {
            if (timeoutMethod == null) {
                return Timeout.NONE;
            }
            try {
                return (Timeout)timeoutMethod.invoke((Object)this.delegate, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return Timeout.NONE;
            }
        }

        private static class TracingCallback
        implements Callback {
            private final Callback delegate;
            private final Context callingContext;

            public TracingCallback(Callback delegate, Context callingContext) {
                this.delegate = delegate;
                this.callingContext = callingContext;
            }

            public void onFailure(Call call, IOException e) {
                try (Scope scope = this.callingContext.makeCurrent();){
                    this.delegate.onFailure(call, e);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (Scope scope = this.callingContext.makeCurrent();){
                    this.delegate.onResponse(call, response);
                }
            }
        }
    }
}

