/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Verify;
import com.google.common.io.BaseEncoding;
import io.airlift.json.JsonCodec;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public class PageSort<T> {
    private static final JsonCodec<List<String>> TOKEN_WITH_SORT_CODEC = JsonCodec.listJsonCodec(String.class);
    private static final String OFFSET_PARAM = "offset";
    private final List<Item<T>> items;

    private PageSort(List<Item<T>> items) {
        this.items = items;
    }

    @SafeVarargs
    public static <T> PageSort<T> sort(Item<T> ... items) {
        Verify.verify((items != null && items.length > 0 ? 1 : 0) != 0, (String)"Sort items cannot be empty", (Object[])new Object[0]);
        return new PageSort<T>(Arrays.stream(items).toList());
    }

    public static <T> Item<T> bigintSort(String name, Extractor<T> extractor) {
        return new Item<T>(name, DataType.BIGINT, extractor);
    }

    public static <T> Item<T> uuidSort(String name, Extractor<T> extractor) {
        return new Item<T>(name, DataType.UUID, extractor);
    }

    public static <T> Item<T> varcharSort(String name, Extractor<T> extractor) {
        return new Item<T>(name, DataType.VARCHAR, extractor);
    }

    String createToken(T element) {
        ArrayList<String> tokens = new ArrayList<String>(this.items.size());
        for (Item<T> item : this.items) {
            String token = item.createToken(element);
            tokens.add(token);
        }
        String token = TOKEN_WITH_SORT_CODEC.toJson(tokens);
        return PageSort.encode(token);
    }

    void bindToken(Query query, String tokenString) {
        try {
            String decodedTokenString = PageSort.decode(tokenString);
            List tokens = (List)TOKEN_WITH_SORT_CODEC.fromJson(decodedTokenString);
            if (tokens.size() != this.items.size()) {
                throw new IllegalArgumentException("Expected " + this.items.size() + " elements in token");
            }
            for (int i = 0; i < tokens.size(); ++i) {
                this.items.get(i).bindToken(query, OFFSET_PARAM + i, (String)tokens.get(i));
            }
        }
        catch (Exception e) {
            throw new CatalogBadRequestException("Bad token: " + tokenString, (Throwable)e);
        }
    }

    List<String> orders() {
        return this.items.stream().map(item -> item.name() + " DESC").toList();
    }

    String conditions() {
        StringJoiner left = new StringJoiner(", ", "(", ")");
        StringJoiner right = new StringJoiner(", ", "(", ")");
        for (int i = 0; i < this.items.size(); ++i) {
            left.add(this.items.get(i).name());
            right.add(":offset" + i);
        }
        return String.valueOf(left) + " < " + String.valueOf(right);
    }

    private static String encode(String value) {
        return BaseEncoding.base64().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String decode(String value) {
        return new String(BaseEncoding.base64().decode((CharSequence)value), StandardCharsets.UTF_8);
    }

    public static class Item<T> {
        private final String name;
        private final DataType dataType;
        private final Extractor<T> extractor;

        private Item(String name, DataType dataType, Extractor<T> extractor) {
            this.name = name;
            this.dataType = dataType;
            this.extractor = extractor;
        }

        private String createToken(T element) {
            Object value = this.extractor.extract(element);
            if (value == null) {
                throw new CatalogInternalServerErrorException("Values for sort token cannot be null");
            }
            return value.toString();
        }

        private void bindToken(Query query, String param, String token) {
            Object value = switch (this.dataType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Long.parseLong(token);
                case 1 -> UUID.fromString(token);
                case 2 -> token;
            };
            query.bind(param, value);
        }

        private String name() {
            return this.name;
        }
    }

    private static enum DataType {
        BIGINT,
        UUID,
        VARCHAR;

    }

    @FunctionalInterface
    public static interface Extractor<T> {
        public Object extract(T var1);
    }
}

