/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.PageData;
import ru.cedrusdata.catalog.core.principal.AccessTokenInfoEx;
import ru.cedrusdata.catalog.core.principal.PrincipalDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalInfoEx;
import ru.cedrusdata.catalog.core.principal.PrincipalType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalInUseException;
import ru.cedrusdata.catalog.spi.exception.CatalogRecursiveRoleGrantException;
import ru.cedrusdata.catalog.spi.model.AccessTokenInfo;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.RoleMemberInfo;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.PrincipalStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcPrincipalStore
implements PrincipalStore {
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_CREATE = "INSERT INTO metastore_principal (\n    principal_id,\n    principal_name,\n    principal_type,\n    hashed_password,\n    active,\n    identified_with,\n    properties,\n    owner_id)\nVALUES (\n    :principal_id,\n    :principal_name,\n    :principal_type,\n    :hashed_password,\n    :active,\n    :identified_with,\n    :properties,\n    :owner_id)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_UPDATE_TEMPLATE = "UPDATE metastore_principal\nSET\n    %s\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_UPDATE_OWNER = "UPDATE metastore_principal\nSET owner_id = :owner_id\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DELETE = "DELETE FROM metastore_principal\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_USER_COUNT = "SELECT\n    COUNT(*)\nFROM metastore_principal\nWHERE principal_type = 0\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_FOR_UPDATE = "SELECT\n    principal_id\nFROM metastore_principal\nWHERE principal_id = :principal_id\n{for-update}\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_INFO = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    ou.principal_name principal_owner_name,\n    u.principal_type,\n    u.active,\n    (SELECT string_agg(r.principal_name, ',') FROM metastore_role_grant rg INNER JOIN metastore_principal r ON rg.role_id = r.principal_id WHERE rg.principal_id = u.principal_id) role_names,\n    u.properties,\n    u.identified_with,\n    sp.provider_name identified_with_name\nFROM metastore_principal u\n    LEFT OUTER JOIN metastore_principal ou ON u.owner_id = ou.principal_id\n    LEFT OUTER JOIN metastore_security_provider sp ON u.identified_with = sp.provider_id\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_LIST = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    ou.principal_name principal_owner_name,\n    u.principal_type,\n    (SELECT string_agg(r.principal_name, ',') FROM metastore_role_grant rg INNER JOIN metastore_principal r ON rg.role_id = r.principal_id WHERE rg.principal_id = u.principal_id) role_names,\n    u.active,\n    u.properties,\n    u.identified_with,\n    sp.provider_name identified_with_name\nFROM metastore_principal u\n    LEFT OUTER JOIN metastore_principal ou ON u.owner_id = ou.principal_id\n    LEFT OUTER JOIN metastore_security_provider sp ON u.identified_with = sp.provider_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_ID = "SELECT\n    u.principal_id\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD_BY_NAME = "WITH RECURSIVE user_roles(role_id) AS (\n    SELECT principal_id\n    FROM metastore_principal\n    WHERE principal_name = :principal_name\n    UNION ALL\n    SELECT rg.role_id\n    FROM metastore_role_grant rg\n        INNER JOIN user_roles r ON rg.principal_id = r.role_id\n)\nSELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    u.principal_type,\n    u.active,\n    (SELECT string_agg(CAST(role_id AS VARCHAR), ',') FROM user_roles) role_ids,\n    u.properties,\n    u.identified_with\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD_BY_ID = "WITH RECURSIVE user_roles(role_id) AS (\n    SELECT principal_id\n    FROM metastore_principal\n    WHERE principal_id = :principal_id\n    UNION ALL\n    SELECT rg.role_id\n    FROM metastore_role_grant rg\n        INNER JOIN user_roles r ON rg.principal_id = r.role_id\n)\nSELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    u.principal_type,\n    u.active,\n    (SELECT string_agg(CAST(role_id AS VARCHAR), ',') FROM user_roles) role_ids,\n    u.properties,\n    u.identified_with\nFROM metastore_principal u\nWHERE u.principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_WITH_PASSWORD = "WITH RECURSIVE user_roles(role_id) AS (\n    SELECT principal_id\n    FROM metastore_principal\n    WHERE principal_name = :principal_name\n    UNION ALL\n    SELECT rg.role_id\n    FROM metastore_role_grant rg\n        INNER JOIN user_roles r ON rg.principal_id = r.role_id\n)\nSELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    u.principal_type,\n    u.active,\n    u.hashed_password,\n    (SELECT string_agg(CAST(role_id AS VARCHAR), ',') FROM user_roles) role_ids,\n    u.properties,\n    u.identified_with\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_BY_ACCESS_TOKEN_ID = "WITH RECURSIVE user_roles(role_id) AS (\n    SELECT principal_id\n    FROM metastore_access_token\n    WHERE access_token_id = :access_token_id\n    UNION ALL\n    SELECT rg.role_id\n    FROM metastore_role_grant rg\n        INNER JOIN user_roles r ON rg.principal_id = r.role_id\n)\nSELECT\n    u.principal_id,\n    u.principal_name,\n    u.owner_id principal_owner_id,\n    u.principal_type,\n    u.active,\n    t.hashed_access_token,\n    (SELECT string_agg(CAST(role_id AS VARCHAR), ',') FROM user_roles) role_ids,\n    u.properties,\n    u.identified_with\nFROM metastore_access_token t\n    INNER JOIN metastore_principal u ON t.principal_id = u.principal_id\nWHERE t.access_token_id = :access_token_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_ROLES = "SELECT\n    principal_id,\n    role_id\nFROM metastore_role_grant\nWHERE principal_id IN ({referenced_role_ids})\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_CREATE = "INSERT INTO metastore_access_token (\n    access_token_id,\n    hashed_access_token,\n    principal_id,\n    description)\nVALUES (\n    :access_token_id,\n    :hashed_access_token,\n    :principal_id,\n    :description)\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_DELETE = "DELETE FROM metastore_access_token\nWHERE :access_token_id = access_token_id\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_LIST = "SELECT\n    at.access_token_id,\n    u.principal_id,\n    u.owner_id principal_owner_id,\n    u.principal_name,\n    at.description\nFROM metastore_access_token at\n    INNER JOIN metastore_principal u ON at.principal_id = u.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_ID_LIST = "SELECT\n    access_token_id\nFROM metastore_access_token\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_LIST = "SELECT\n    principal_id,\n    principal_name\nFROM metastore_principal\nWHERE principal_type = 1\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_NAMES = "SELECT\n    principal_id,\n    principal_name\nFROM metastore_principal\nWHERE principal_id IN ({referenced_role_ids})\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_GRANT = "INSERT INTO metastore_role_grant (\n    principal_id,\n    role_id)\nVALUES (\n    :principal_id,\n    :role_id)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_REVOKE = "DELETE FROM metastore_role_grant\nWHERE principal_id = :principal_id AND role_id = :role_id\n";
    @Language(value="SQL")
    private static final String SQL_PUBLIC_ROLE_MEMBERS = "SELECT\n    p.principal_name\nFROM metastore_principal p\nWHERE p.principal_id != :role_id\nORDER BY p.principal_name\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_MEMBERS = "SELECT\n    p.principal_name\nFROM metastore_role_grant g\n    INNER JOIN metastore_principal p ON g.principal_id = p.principal_id\nWHERE g.role_id = :role_id\nORDER BY p.principal_name\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<PrincipalInfoEx> principalListPageProcessorFactory;
    private final PageProcessorFactory<AccessTokenInfoEx> accessTokenListPageProcessorFactory;

    @Inject
    public JdbcPrincipalStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.principalListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_PRINCIPAL_LIST, PageSort.sort(PageSort.uuidSort("u.principal_id", PrincipalInfoEx::id))), maxPageSize);
        this.accessTokenListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ACCESS_TOKEN_LIST, PageSort.sort(PageSort.varcharSort("at.access_token_id", info -> info.info().getAccessTokenId()))), maxPageSize);
    }

    @Override
    public Optional<UUID> createPrincipalIfNotExists(String principalName, PrincipalType principalType, String hashedPassword, Map<UUID, String> roles, boolean active, UUID identifiedWith, Map<String, String> properties, UUID ownerId) {
        UUID principalId = UUID.randomUUID();
        return this.accessor.execute(handle -> (Optional)handle.inTransaction(txHandle -> {
            boolean created;
            boolean bl = created = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_PRINCIPAL_CREATE).bind("principal_id", principalId)).bind("principal_name", principalName)).bind("principal_type", principalType.getValue())).bind("hashed_password", hashedPassword)).bind("active", (short)(active ? 1 : 0))).bind("identified_with", identifiedWith)).bind("properties", JdbcUtils.propertiesToString(properties))).bind("owner_id", ownerId)).execute() == 1;
            if (created) {
                for (Map.Entry role : roles.entrySet()) {
                    this.grantRoleInTransaction(txHandle, principalName, principalId, (UUID)role.getKey(), (String)role.getValue());
                }
            }
            return created ? Optional.of(principalId) : Optional.empty();
        }));
    }

    @Override
    public boolean updatePrincipalIfExists(UUID principalId, String newPrincipalName, boolean newActive, UUID newIdentifiedWith, Map<String, String> newProperties, Optional<String> newHashedPassword) {
        StringJoiner sqlJoiner = new StringJoiner(",\n");
        sqlJoiner.add("principal_name = :principal_name");
        sqlJoiner.add("active = :active");
        sqlJoiner.add("identified_with = :identified_with");
        sqlJoiner.add("properties = :properties");
        if (newHashedPassword.isPresent()) {
            sqlJoiner.add("hashed_password = :hashed_password");
        }
        String sql = String.format(SQL_PRINCIPAL_UPDATE_TEMPLATE, sqlJoiner);
        try {
            return this.accessor.execute(handle -> {
                Update update = handle.createUpdate(sql);
                update.bind("principal_id", principalId);
                update.bind("principal_name", newPrincipalName);
                update.bind("active", (short)(newActive ? 1 : 0));
                update.bind("identified_with", newIdentifiedWith);
                update.bind("properties", JdbcUtils.propertiesToString(newProperties));
                if (newHashedPassword.isPresent()) {
                    update.bind("hashed_password", (String)newHashedPassword.get());
                }
                return update.execute() == 1;
            });
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogPrincipalAlreadyExistsException(newPrincipalName);
            }
            throw e;
        }
    }

    @Override
    public boolean updatePrincipalOwnerIfExists(UUID principalId, UUID newOwnerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_PRINCIPAL_UPDATE_OWNER).bind("principal_id", principalId)).bind("owner_id", newOwnerId)).execute() == 1);
    }

    @Override
    public boolean deletePrincipalIfExists(UUID principalId, String principalName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_PRINCIPAL_DELETE).bind("principal_id", principalId)).execute() == 1);
        }
        catch (Throwable e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogPrincipalInUseException(principalName);
            }
            throw e;
        }
    }

    @Override
    public Optional<UUID> getPrincipalIdByName(String principalName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_ID).bind("principal_name", principalName)).map((rs, ctx) -> this.accessor.getUuid(rs, "principal_id")).findOne());
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByName(String principalName, boolean readPassword) {
        if (readPassword) {
            return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_WITH_PASSWORD).bind("principal_name", principalName)).map((rs, ctx) -> this.toDetails(rs, true)).findOne());
        }
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD_BY_NAME).bind("principal_name", principalName)).map((rs, ctx) -> this.toDetails(rs, false)).findOne());
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsById(UUID principalId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD_BY_ID).bind("principal_id", principalId)).map((rs, ctx) -> this.toDetails(rs, false)).findOne());
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByAccessTokenId(String accessTokenId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_BY_ACCESS_TOKEN_ID).bind("access_token_id", accessTokenId)).map((rs, ctx) -> new PrincipalDetails(this.accessor.getUuid(rs, "principal_id"), rs.getString("principal_name"), this.accessor.getOptionalUuid(rs, "principal_owner_id"), JdbcPrincipalStore.principalTypeFromShort(rs.getShort("principal_type")), rs.getShort("active") == 1, Optional.of(rs.getString("hashed_access_token")), JdbcPrincipalStore.parseRoleIds(rs.getString("role_ids")), JdbcUtils.stringToProperties(rs.getString("properties")), this.accessor.getOptionalUuid(rs, "identified_with"))).findOne());
    }

    private static PrincipalType principalTypeFromShort(short value) {
        return PrincipalType.resolveFromShort(value);
    }

    private static PrincipalType principalTypeFromString(String principalType) {
        return PrincipalType.resolveFromString(principalType).orElseThrow(() -> new IllegalArgumentException("Unsupported principal type: " + principalType));
    }

    private static Set<UUID> parseRoleIds(String value) {
        if (value == null) {
            return Set.of();
        }
        List tokens = Splitter.on((char)',').splitToList((CharSequence)value);
        HashSet<UUID> result = HashSet.newHashSet(tokens.size());
        for (String token : tokens) {
            result.add(UUID.fromString(token));
        }
        return result;
    }

    @Override
    public Optional<PrincipalInfoEx> getPrincipal(String principalName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_INFO).bind("principal_name", principalName)).map((rs, ctx) -> this.toPrincipalInfo(rs)).findOne());
    }

    @Override
    public PageData<PrincipalInfoEx> listPrincipals(Optional<String> principalType, Optional<Boolean> active, ResultPage page, com.google.common.base.Predicate<PrincipalInfoEx> predicate) {
        List<QueryCondition> conditions;
        if (principalType.isPresent() || active.isPresent()) {
            conditions = new ArrayList(2);
            if (principalType.isPresent()) {
                conditions.add(QueryCondition.eq("u.principal_type", JdbcPrincipalStore.principalTypeFromString(principalType.get()).getValue(), "principal_type"));
            }
            if (active.isPresent()) {
                conditions.add(QueryCondition.eq("u.active", (short)(active.get() != false ? 1 : 0), "active"));
            }
        } else {
            conditions = List.of();
        }
        return this.principalListPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), this::toPrincipalInfo, (Predicate<PrincipalInfoEx>)predicate, PageData::new);
    }

    private PrincipalInfoEx toPrincipalInfo(ResultSet rs) throws SQLException {
        UUID id = this.accessor.getUuid(rs, "principal_id");
        String name = rs.getString("principal_name");
        Optional<UUID> ownerId = this.accessor.getOptionalUuid(rs, "principal_owner_id");
        PrincipalInfo info = new PrincipalInfo(name, JdbcPrincipalStore.principalTypeFromShort(rs.getShort("principal_type")).getCaption(), rs.getString("principal_owner_name"), Boolean.valueOf(rs.getShort("active") == 1), rs.getString("identified_with_name"), JdbcPrincipalStore.parseRoleNames(rs.getString("role_names"), "builtin.public".equalsIgnoreCase(name)), JdbcUtils.stringToProperties(rs.getString("properties")));
        return new PrincipalInfoEx(id, ownerId, info);
    }

    private AccessTokenInfoEx toAccessTokenInfo(ResultSet rs) throws SQLException {
        UUID id = this.accessor.getUuid(rs, "principal_id");
        Optional<UUID> ownerId = this.accessor.getOptionalUuid(rs, "principal_owner_id");
        AccessTokenInfo info = new AccessTokenInfo(rs.getString("access_token_id"), rs.getString("principal_name"), rs.getString("description"));
        return new AccessTokenInfoEx(id, ownerId, info);
    }

    private static Set<String> parseRoleNames(String value, boolean isPublic) {
        if (value == null) {
            return isPublic ? Set.of() : Set.of("builtin.public");
        }
        String[] tokens = value.split(",");
        HashSet<String> res = new HashSet<String>(Arrays.asList(tokens));
        if (!isPublic) {
            res.add("builtin.public");
        }
        return res;
    }

    @Override
    public long countUserPrincipals() {
        return this.accessor.execute(handle -> (Long)handle.createQuery(SQL_PRINCIPAL_USER_COUNT).map((rs, ctx) -> rs.getLong(1)).one());
    }

    @Override
    public void createAccessToken(UUID principalId, String principalName, String accessTokenId, String hashAccessToken, String description) {
        try {
            this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ACCESS_TOKEN_CREATE).bind("access_token_id", accessTokenId)).bind("hashed_access_token", hashAccessToken)).bind("principal_id", principalId)).bind("description", description)).execute());
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogPrincipalDoesNotExistException(principalName);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteAccessTokenIfExists(String accessTokenId) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ACCESS_TOKEN_DELETE).bind("access_token_id", accessTokenId)).execute() == 1);
    }

    @Override
    public AccessTokenListResponse listAccessTokens(ResultPage page, Optional<UUID> principalId, com.google.common.base.Predicate<AccessTokenInfoEx> predicate) {
        List conditions = principalId.isPresent() ? List.of(QueryCondition.eq("at.principal_id", principalId, "principal_id")) : List.of();
        return this.accessTokenListPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), this::toAccessTokenInfo, (Predicate<AccessTokenInfoEx>)predicate, (items, nextPageToken) -> new AccessTokenListResponse(items.stream().map(AccessTokenInfoEx::info).toList(), nextPageToken));
    }

    @Override
    public List<String> listAccessTokenIds(UUID principalId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_ACCESS_TOKEN_ID_LIST).bind("principal_id", principalId)).map((rs, ctx) -> rs.getString("access_token_id")).list());
    }

    @Override
    public Map<String, UUID> listRoles() {
        record RoleIdAndName(UUID id, String name) {
        }
        List roles = this.accessor.execute(handle -> handle.createQuery(SQL_ROLE_LIST).map((rs, ctx) -> new RoleIdAndName(this.accessor.getUuid(rs, "principal_id"), rs.getString("principal_name"))).list());
        HashMap<String, UUID> res = HashMap.newHashMap(roles.size());
        for (RoleIdAndName role : roles) {
            res.put(role.name(), role.id());
        }
        return res;
    }

    @Override
    public boolean grantRoles(UUID principalId, String principalName, Map<UUID, String> roles) {
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            this.lockPrincipal(txHandle, principalName, principalId);
            boolean updated = false;
            for (Map.Entry entry : roles.entrySet()) {
                if (!this.grantRoleInTransaction(txHandle, principalName, principalId, (UUID)entry.getKey(), (String)entry.getValue())) continue;
                updated = true;
            }
            return updated;
        }));
    }

    private boolean grantRoleInTransaction(Handle txHandle, String principalName, UUID principalId, UUID roleId, String roleName) {
        Verify.verify((boolean)txHandle.isInTransaction());
        Optional<List<String>> loop = this.checkRoleLoop(txHandle, principalName, principalId, roleId);
        if (loop.isPresent()) {
            throw new NestedStoreException((RuntimeException)new CatalogRecursiveRoleGrantException(principalName, roleName, loop.get()));
        }
        return ((Update)((Update)txHandle.createUpdate(SQL_ROLE_GRANT).bind("principal_id", principalId)).bind("role_id", roleId)).execute() == 1;
    }

    private Optional<List<String>> checkRoleLoop(Handle txHandle, String principalName, UUID principalId, UUID roleId) {
        Verify.verify((boolean)txHandle.isInTransaction());
        if (principalId.equals(roleId)) {
            return Optional.of(List.of(principalName, principalName));
        }
        ArrayList<RoleLink> links = new ArrayList<RoleLink>();
        HashSet<UUID> allRoleIds = new HashSet<UUID>();
        allRoleIds.add(roleId);
        Set<UUID> roleIdsToCheck = Set.of(roleId);
        while (!roleIdsToCheck.isEmpty()) {
            String sql = SQL_PRINCIPAL_ROLES.replace("{referenced_role_ids}", roleIdsToCheck.stream().map(r -> "?").collect(Collectors.joining(", ")));
            Query query = txHandle.createQuery(sql);
            int i = 0;
            for (UUID id : roleIdsToCheck) {
                query.bind(i, id);
            }
            List newLinks = query.map((rs, ctx) -> new RoleLink(this.accessor.getUuid(rs, "principal_id"), this.accessor.getUuid(rs, "role_id"))).list();
            HashSet<UUID> newRoleIdsToCheck = new HashSet<UUID>();
            for (RoleLink link : newLinks) {
                links.add(link);
                if (principalId.equals(link.toId())) {
                    return Optional.of(this.buildRoleChain(txHandle, principalId, roleId, links));
                }
                if (!allRoleIds.add(link.toId())) continue;
                newRoleIdsToCheck.add(link.toId());
            }
            roleIdsToCheck = newRoleIdsToCheck;
        }
        return Optional.empty();
    }

    private List<String> buildRoleChain(Handle txHandle, UUID principalId, UUID roleId, List<RoleLink> links) {
        record RoleWithName(UUID id, String name) {
        }
        HashMap<UUID, Set<UUID>> roleGraph = new HashMap<UUID, Set<UUID>>();
        for (RoleLink entry : links) {
            roleGraph.computeIfAbsent(entry.fromId(), k -> new HashSet()).add(entry.toId());
        }
        List<UUID> roleChain = this.buildRoleIdChain(roleGraph, roleId, principalId);
        String sql = SQL_PRINCIPAL_NAMES.replace("{referenced_role_ids}", roleChain.stream().map(id -> "?").collect(Collectors.joining(", ")));
        Query query = txHandle.createQuery(sql);
        for (int i = 0; i < roleChain.size(); ++i) {
            query.bind(i, roleChain.get(i));
        }
        List roleNames = query.map((rs, ctx) -> new RoleWithName(this.accessor.getUuid(rs, "principal_id"), rs.getString("principal_name"))).list();
        HashMap<UUID, String> roleIdToName = HashMap.newHashMap(roleNames.size());
        for (RoleWithName entry : roleNames) {
            roleIdToName.put(entry.id(), entry.name());
        }
        ArrayList<String> res = new ArrayList<String>(roleChain.size() + 1);
        for (UUID currentRoleId : roleChain) {
            String currentRoleName = (String)roleIdToName.get(currentRoleId);
            if (currentRoleName == null) {
                currentRoleName = "<dropped>";
            }
            res.add(currentRoleName);
        }
        res.add((String)res.get(0));
        return res;
    }

    private List<UUID> buildRoleIdChain(Map<UUID, Set<UUID>> graph, UUID startRoleId, UUID endRoleId) {
        ArrayList<UUID> res = new ArrayList<UUID>();
        this.buildRoleIdChain(graph, startRoleId, endRoleId, new ArrayList<UUID>(), res);
        Verify.verify((!res.isEmpty() ? 1 : 0) != 0);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRoleIdChain(Map<UUID, Set<UUID>> graph, UUID roleId, UUID endRoleId, List<UUID> rolesSoFar, List<UUID> res) {
        if (!res.isEmpty()) {
            return;
        }
        rolesSoFar.add(roleId);
        try {
            if (roleId.equals(endRoleId)) {
                res.addAll(rolesSoFar);
                return;
            }
            for (UUID childRoleId : graph.getOrDefault(roleId, Set.of())) {
                this.buildRoleIdChain(graph, childRoleId, endRoleId, rolesSoFar, res);
            }
        }
        finally {
            rolesSoFar.removeLast();
        }
    }

    private void lockPrincipal(Handle txHandle, String principalName, UUID principalId) {
        Verify.verify((boolean)txHandle.isInTransaction());
        boolean present = ((Query)txHandle.createQuery(this.accessor.forUpdate(SQL_PRINCIPAL_FOR_UPDATE)).bind("principal_id", principalId)).map((rs, ctx) -> this.accessor.getUuid(rs, "principal_id")).findOne().isPresent();
        if (!present) {
            throw new CatalogPrincipalDoesNotExistException(principalName);
        }
    }

    @Override
    public boolean revokeRoles(UUID principalId, Set<UUID> roleIds) {
        return this.accessor.execute(handle -> {
            PreparedBatch batch = handle.prepareBatch(SQL_ROLE_REVOKE);
            for (UUID roleId : roleIds) {
                ((PreparedBatch)((PreparedBatch)batch.bind("principal_id", principalId)).bind("role_id", roleId)).add();
            }
            int[] results = batch.execute();
            return Arrays.stream(results).anyMatch(value -> value > 0);
        });
    }

    @Override
    public List<RoleMemberInfo> roleMembers(UUID roleId, boolean isPublic) {
        String sql = isPublic ? SQL_PUBLIC_ROLE_MEMBERS : SQL_ROLE_MEMBERS;
        return this.accessor.execute(handle -> ((Query)handle.createQuery(sql).bind("role_id", roleId)).map((rs, ctx) -> new RoleMemberInfo(rs.getString("principal_name"))).list());
    }

    private PrincipalDetails toDetails(ResultSet rs, boolean withPassword) throws SQLException {
        return new PrincipalDetails(this.accessor.getUuid(rs, "principal_id"), rs.getString("principal_name"), this.accessor.getOptionalUuid(rs, "principal_owner_id"), JdbcPrincipalStore.principalTypeFromShort(rs.getShort("principal_type")), rs.getShort("active") == 1, withPassword ? Optional.ofNullable(rs.getString("hashed_password")) : Optional.empty(), JdbcPrincipalStore.parseRoleIds(rs.getString("role_ids")), JdbcUtils.stringToProperties(rs.getString("properties")), this.accessor.getOptionalUuid(rs, "identified_with"));
    }

    private record RoleLink(UUID fromId, UUID toId) {
    }
}

