/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ru.cedrusdata.catalog.tracing.TracingProvider;
import ru.cedrusdata.catalog.tracing.TracingScopedSpan;

public class StoreTracingInterceptor
implements MethodInterceptor {
    private Tracer tracer;

    @Inject
    public void setTracingProvider(TracingProvider tracingProvider) {
        this.tracer = tracingProvider.tracerForStore().get();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Span span = this.startSpan(invocation.getMethod().getName());
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Object object = invocation.proceed();
            return object;
        }
    }

    private Span startSpan(String methodName) {
        return this.tracer.spanBuilder("store." + methodName).startSpan();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Traceable {
    }
}

