/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import io.airlift.jaxrs.ParsingException;
import io.airlift.log.Logger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CherrypickAncestorCommitException;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.DuplicateWAPCommitException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.rest.responses.ErrorResponse;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.server.filters.RequestClassifierFilter;
import ru.cedrusdata.catalog.server.filters.RequestIdFilter;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthenticationException;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthorizationException;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.spi.exception.CatalogPropertyConflictException;
import ru.cedrusdata.catalog.spi.exception.CatalogServiceUnavailableException;
import ru.cedrusdata.catalog.spi.exception.CatalogUnsupportedOperationException;
import ru.cedrusdata.catalog.spi.exception.HttpErrorCode;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceNotEmptyException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.CatalogError;
import ru.cedrusdata.catalog.spi.model.CatalogErrorResponse;

public class ServerExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger logger = Logger.get(ServerExceptionMapper.class);
    @Context
    private HttpServletRequest request;

    public Response toResponse(Throwable exception) {
        ResourceType.Type type = RequestClassifierFilter.getRequestType(this.request);
        String correlationId = RequestIdFilter.getCorrelation(this.request);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ResourceType.Type.CATALOG, ResourceType.Type.CATALOG_MANAGEMENT_READ, ResourceType.Type.OTHER -> this.toCatalogError(exception, correlationId);
            case ResourceType.Type.ICEBERG -> ServerExceptionMapper.toIcebergError(exception, correlationId);
        };
    }

    private Response toCatalogError(Throwable exception, String correlationId) {
        CatalogException catalogException2;
        if (exception instanceof WebApplicationException) {
            WebApplicationException webApplicationException = (WebApplicationException)exception;
            Map details = correlationId != null ? Map.of("correlation-id", correlationId) : Map.of();
            return Response.status((int)webApplicationException.getResponse().getStatus()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new CatalogErrorResponse(new CatalogError(Integer.valueOf(CatalogErrorCode.GENERIC_ERROR.getCode()), webApplicationException.getMessage(), details))).build();
        }
        if (exception instanceof ParsingException) {
            exception = new CatalogBadRequestException(exception.getMessage(), exception.getCause());
        }
        Object catalogException = exception instanceof CatalogException ? (catalogException2 = (CatalogException)exception) : new CatalogInternalServerErrorException(exception.getMessage(), exception);
        HashMap<String, String> details = new HashMap<String, String>(catalogException.getDetails());
        if (correlationId != null) {
            details.put("correlation-id", correlationId);
        }
        CatalogError catalogError = new CatalogError(Integer.valueOf(catalogException.getErrorCode().getCode()), catalogException.getOriginalMessage(), details);
        CatalogErrorResponse errorResponse = new CatalogErrorResponse(catalogError);
        HttpErrorCode httpErrorCode = ServerExceptionMapper.toHttpErrorCode(catalogException.getErrorCode());
        ServerExceptionMapper.logException(exception, correlationId, httpErrorCode);
        return Response.status((int)httpErrorCode.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorResponse).build();
    }

    private static Response toIcebergError(Throwable exception, String correlationId) {
        HttpErrorCode httpErrorCode;
        Throwable fileNotFoundException;
        if (exception instanceof ParsingException) {
            exception = new BadRequestException(exception.getCause(), exception.getMessage(), new Object[0]);
        }
        if (exception instanceof RuntimeIOException) {
            RuntimeIOException runtimeIOException = (RuntimeIOException)exception;
            Throwable throwable = exception.getCause();
            if (throwable instanceof FileNotFoundException) {
                fileNotFoundException = (FileNotFoundException)throwable;
                exception = new NotFoundException(fileNotFoundException.getCause(), fileNotFoundException.getMessage(), new Object[0]);
            } else {
                IOException cause = runtimeIOException.getCause();
                if (cause != null) {
                    String newErrorMessage = String.format("%s (%s)", runtimeIOException.getMessage(), cause.getMessage());
                    exception = new RuntimeIOException(runtimeIOException.getCause(), newErrorMessage, new Object[0]);
                }
            }
        }
        if (exception instanceof CatalogException) {
            CatalogException catalogException;
            CatalogException catalogException2 = catalogException = (CatalogException)exception;
            Objects.requireNonNull(catalogException2);
            fileNotFoundException = catalogException2;
            int cause = 0;
            exception = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IcebergNamespaceAlreadyExistsException.class, IcebergNamespaceDoesNotExistException.class, IcebergNamespaceNotEmptyException.class, IcebergObjectAlreadyExistsException.class, IcebergObjectCommitFailedException.class, IcebergObjectDoesNotExistException.class, CatalogAuthenticationException.class, CatalogAuthorizationException.class, CatalogBadRequestException.class, CatalogUnsupportedOperationException.class, CatalogPropertyConflictException.class, CatalogServiceUnavailableException.class}, (Object)fileNotFoundException, cause)) {
                case 0 -> {
                    IcebergNamespaceAlreadyExistsException e = (IcebergNamespaceAlreadyExistsException)fileNotFoundException;
                    yield new AlreadyExistsException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 1 -> {
                    IcebergNamespaceDoesNotExistException e = (IcebergNamespaceDoesNotExistException)fileNotFoundException;
                    yield new NoSuchNamespaceException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 2 -> {
                    IcebergNamespaceNotEmptyException e = (IcebergNamespaceNotEmptyException)fileNotFoundException;
                    yield new NamespaceNotEmptyException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 3 -> {
                    IcebergObjectAlreadyExistsException e = (IcebergObjectAlreadyExistsException)fileNotFoundException;
                    yield new AlreadyExistsException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 4 -> {
                    IcebergObjectCommitFailedException e = (IcebergObjectCommitFailedException)fileNotFoundException;
                    yield new CommitFailedException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 5 -> {
                    IcebergObjectDoesNotExistException e = (IcebergObjectDoesNotExistException)fileNotFoundException;
                    Optional objectTypeString = e.getObjectType();
                    if (objectTypeString.isPresent() && CedrusDataIcebergObjectType.TABLE.caption().equals(objectTypeString.get())) {
                        yield new NoSuchTableException(e.getCause(), e.getMessage(), new Object[0]);
                    }
                    if (objectTypeString.isPresent() && CedrusDataIcebergObjectType.VIEW.caption().equals(objectTypeString.get())) {
                        yield new NoSuchViewException(e.getCause(), e.getMessage(), new Object[0]);
                    }
                    yield new ServiceFailureException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 6 -> {
                    CatalogAuthenticationException e = (CatalogAuthenticationException)fileNotFoundException;
                    yield new NotAuthorizedException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 7 -> {
                    CatalogAuthorizationException e = (CatalogAuthorizationException)fileNotFoundException;
                    yield new ForbiddenException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 8 -> {
                    CatalogBadRequestException e = (CatalogBadRequestException)fileNotFoundException;
                    yield new BadRequestException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 9 -> {
                    CatalogUnsupportedOperationException e = (CatalogUnsupportedOperationException)fileNotFoundException;
                    yield new BadRequestException(e.getCause(), e.getMessage(), new Object[0]);
                }
                case 10 -> {
                    CatalogPropertyConflictException e = (CatalogPropertyConflictException)fileNotFoundException;
                    yield new UnprocessableEntityException(e.getMessage(), new Object[0]);
                }
                case 11 -> {
                    CatalogServiceUnavailableException e = (CatalogServiceUnavailableException)fileNotFoundException;
                    yield new ServiceUnavailableException(e.getCause(), e.getMessage(), new Object[0]);
                }
                default -> new ServiceFailureException(exception.getCause(), exception.getMessage(), new Object[0]);
            };
        }
        Throwable throwable = exception;
        Objects.requireNonNull(throwable);
        fileNotFoundException = throwable;
        int cause = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlreadyExistsException.class, BadRequestException.class, CherrypickAncestorCommitException.class, CommitFailedException.class, CommitStateUnknownException.class, DuplicateWAPCommitException.class, ForbiddenException.class, NamespaceNotEmptyException.class, NoSuchIcebergTableException.class, NoSuchNamespaceException.class, NoSuchTableException.class, NoSuchViewException.class, NotAuthorizedException.class, NotFoundException.class, RuntimeIOException.class, ServiceFailureException.class, ServiceUnavailableException.class, UnprocessableEntityException.class, ValidationException.class, CleanableFailure.class, RESTException.class}, (Object)fileNotFoundException, cause)) {
            case 0: {
                AlreadyExistsException ignored = (AlreadyExistsException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case 1: {
                BadRequestException ignored = (BadRequestException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 2: {
                CherrypickAncestorCommitException ignored = (CherrypickAncestorCommitException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 3: {
                CommitFailedException ignored = (CommitFailedException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case 4: {
                CommitStateUnknownException ignored = (CommitStateUnknownException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 5: {
                DuplicateWAPCommitException ignored = (DuplicateWAPCommitException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 6: {
                ForbiddenException ignored = (ForbiddenException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_403;
                break;
            }
            case 7: {
                NamespaceNotEmptyException ignored = (NamespaceNotEmptyException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 8: {
                NoSuchIcebergTableException ignored = (NoSuchIcebergTableException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case 9: {
                NoSuchNamespaceException ignored = (NoSuchNamespaceException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case 10: {
                NoSuchTableException ignored = (NoSuchTableException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case 11: {
                NoSuchViewException ignored = (NoSuchViewException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case 12: {
                NotAuthorizedException ignored = (NotAuthorizedException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_401;
                break;
            }
            case 13: {
                NotFoundException ignored = (NotFoundException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            case 14: {
                RuntimeIOException ignored = (RuntimeIOException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            case 15: {
                ServiceFailureException ignored = (ServiceFailureException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            case 16: {
                ServiceUnavailableException ignored = (ServiceUnavailableException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_503;
                break;
            }
            case 17: {
                UnprocessableEntityException ignored = (UnprocessableEntityException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case 18: {
                ValidationException ignored = (ValidationException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 19: {
                CleanableFailure ignored = (CleanableFailure)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case 20: {
                RESTException ignored = (RESTException)fileNotFoundException;
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            default: {
                HttpErrorCode httpErrorCode2 = httpErrorCode = null;
            }
        }
        if (httpErrorCode == null) {
            exception = new ServiceFailureException(exception, exception.getMessage() != null ? exception.getMessage() : "Unexpected exception", new Object[0]);
            httpErrorCode = HttpErrorCode.CODE_500;
        }
        ServerExceptionMapper.logException(exception, correlationId, httpErrorCode);
        Object message = exception.getMessage();
        if (correlationId != null) {
            message = (String)message + " (correlation-id " + correlationId + ")";
        }
        ErrorResponse response = ErrorResponse.builder().withMessage((String)message).withType(exception.getClass().getName()).responseCode(Integer.valueOf(httpErrorCode.getCode())).withStackTrace(exception).build();
        return Response.status((int)response.code()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
    }

    private static HttpErrorCode toHttpErrorCode(CatalogErrorCode catalogErrorCode) {
        HttpErrorCode httpErrorCode;
        switch (catalogErrorCode) {
            default: {
                throw new MatchException(null, null);
            }
            case GENERIC_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_500;
                break;
            }
            case BAD_REQUEST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_400;
                break;
            }
            case AUTHENTICATION_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_401;
                break;
            }
            case AUTHORIZATION_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_403;
                break;
            }
            case UNSUPPORTED_OPERATION: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_406;
                break;
            }
            case UNPROCESSABLE_ENTITY: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case SERVICE_UNAVAILABLE: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_503;
                break;
            }
            case CLIENT_ERROR: {
                HttpErrorCode httpErrorCode2 = null;
                break;
            }
            case PRINCIPAL_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case PRINCIPAL_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case ACCESS_TOKEN_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case RECURSIVE_ROLE_GRANT: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case PRINCIPAL_IN_USE_EXCEPTION: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case FILE_SYSTEM_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case FILE_SYSTEM_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case FILE_SYSTEM_IN_USE: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case FILE_SYSTEM_STOPPING: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case FILE_SYSTEM_CHECK_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case ICEBERG_CATALOG_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case ICEBERG_CATALOG_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case ICEBERG_CATALOG_IN_USE: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case ICEBERG_CATALOG_CHECK_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case ICEBERG_NAMESPACE_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case ICEBERG_NAMESPACE_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case ICEBERG_NAMESPACE_NOT_EMPTY: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case ICEBERG_OBJECT_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case ICEBERG_OBJECT_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case ICEBERG_OBJECT_COMMIT_FAILED: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case MAINTENANCE_OPERATION_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case MAINTENANCE_JOB_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case MAINTENANCE_JOB_ALREADY_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case COMPUTE_ENGINE_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case COMPUTE_ENGINE_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case COMPUTE_ENGINE_STOPPING: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case COMPUTE_ENGINE_CHECK_ERROR: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case OBJECT_GROUP_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case OBJECT_GROUP_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case OBJECT_GROUP_IN_USE: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case OBJECT_GROUP_ITEM_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case OBJECT_GROUP_ITEM_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case SECURITY_PROVIDER_DOESNT_EXIST: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_404;
                break;
            }
            case SECURITY_PROVIDER_ALREADY_EXISTS: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_409;
                break;
            }
            case SECURITY_PROVIDER_IN_USE: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case SECURITY_PROVIDER_STOPPING: {
                HttpErrorCode httpErrorCode2 = HttpErrorCode.CODE_422;
                break;
            }
            case SECURITY_PROVIDER_CHECK_ERROR: {
                HttpErrorCode httpErrorCode2 = httpErrorCode = HttpErrorCode.CODE_422;
            }
        }
        if (httpErrorCode == null) {
            httpErrorCode = HttpErrorCode.CODE_500;
        }
        return httpErrorCode;
    }

    private static void logException(Throwable exception, String correlationId, HttpErrorCode httpErrorCode) {
        if (httpErrorCode == HttpErrorCode.CODE_500) {
            String message = (String)(correlationId != null ? "(correlation-id " + correlationId + ") " : "") + exception.getMessage();
            logger.warn(exception, message);
        }
    }
}

