/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.inject.Inject;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.filters.AuthenticationFilter;
import ru.cedrusdata.catalog.server.filters.RequestClassifierFilter;
import ru.cedrusdata.catalog.server.filters.RequestIdFilter;
import ru.cedrusdata.catalog.server.filters.ServerInitializedFilter;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;

public class ResourceDynamicFeature
implements DynamicFeature {
    private final ServerInitializationInfo serverInitializationInfo;
    private final AuthenticationFilter catalogAuthenticationFilter;

    @Inject
    public ResourceDynamicFeature(ServerInitializationInfo serverInitializationInfo, AuthenticationFilter catalogAuthenticationFilter) {
        this.serverInitializationInfo = serverInitializationInfo;
        this.catalogAuthenticationFilter = catalogAuthenticationFilter;
    }

    private static ResourceType.Type extractType(ResourceInfo resourceInfo) {
        Optional<ResourceType.Type> type = ResourceDynamicFeature.extractAnnotation(resourceInfo, ResourceType.class).map(ResourceType::value);
        if (type.isPresent()) {
            return type.get();
        }
        return ResourceType.Type.OTHER;
    }

    private static ResourceSecurity.Type extractSecurityType(ResourceInfo resourceInfo) {
        return ResourceDynamicFeature.extractAnnotation(resourceInfo, ResourceSecurity.class).map(ResourceSecurity::value).orElse(ResourceSecurity.Type.AUTHENTICATED);
    }

    private static <T extends Annotation> Optional<T> extractAnnotation(ResourceInfo resourceInfo, Class<T> annotationClazz) {
        T value = resourceInfo.getResourceMethod().getAnnotation(annotationClazz);
        if (value != null) {
            return Optional.of(value);
        }
        for (Class<?> clazz = resourceInfo.getResourceClass(); clazz != null; clazz = clazz.getDeclaringClass()) {
            value = clazz.getAnnotation(annotationClazz);
            if (value == null) continue;
            return Optional.of(value);
        }
        ResourceDynamicFeature.verifyNotCedrusDataCatalogResource(resourceInfo, annotationClazz);
        return Optional.empty();
    }

    private static void verifyNotCedrusDataCatalogResource(ResourceInfo resourceInfo, Class<?> annotationClazz) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null && resourceMethod.getDeclaringClass().getPackageName().startsWith("ru.cedrusdata.catalog.")) {
            throw new IllegalArgumentException(String.format("CedrusData Catalog resource is not annotated with @%s: %s.%s", annotationClazz.getSimpleName(), resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ResourceType.Type type = ResourceDynamicFeature.extractType(resourceInfo);
        context.register((Object)new RequestIdFilter());
        context.register((Object)new RequestClassifierFilter(type));
        context.register((Object)new ServerInitializedFilter(this.serverInitializationInfo));
        ResourceSecurity.Type securityType = ResourceDynamicFeature.extractSecurityType(resourceInfo);
        if (securityType == ResourceSecurity.Type.AUTHENTICATED) {
            context.register((Object)this.catalogAuthenticationFilter);
        }
    }
}

