/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.util.Objects;
import ru.cedrusdata.catalog.server.CatalogServer;

public class CedrusDataCatalogServer {
    private CedrusDataCatalogServer() {
    }

    public static void main(String[] args) {
        String javaVersion = Strings.nullToEmpty((String)StandardSystemProperty.JAVA_VERSION.value());
        String majorVersion = javaVersion.split("\\D", 2)[0];
        Integer major = Ints.tryParse((String)majorVersion);
        if (major == null || major < 21) {
            System.err.println(String.format("ERROR: CedrusData Catalog requires Java 21+ (found %s)", javaVersion));
            System.exit(1);
        }
        String version = CatalogServer.class.getPackage().getImplementationVersion();
        new CatalogServer().start(Objects.requireNonNullElse(version, "unknown"));
    }
}

