/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;

@Path(value="")
@ResourceType(value=ResourceType.Type.CATALOG)
@ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
public class CedrusCatalogUiStaticResource {
    public static final String CATALOG_UI_LOCATION = "/ui";
    public static final String CATALOG_FILES_LOCATION = "/cedrus-catalog";

    @ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
    @GET
    public Response getRoot() {
        return Response.seeOther((URI)URI.create("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
    @GET
    @Path(value="/ui")
    public Response getCatalogUi() {
        return Response.seeOther((URI)URI.create("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
    @POST
    @Path(value="/ui/{path: .*}")
    public Response postCatalogFile(@PathParam(value="path") String path) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
    @GET
    @Path(value="/ui/{path: .*}")
    public Response getCatalogFile(@PathParam(value="path") String path, @Context HttpServletRequest request, @Context ServletContext servletContext, @Context SecurityContext securityContext) throws IOException {
        String fullPath;
        if (path.isEmpty()) {
            path = "index.html";
        }
        if (!CedrusCatalogUiStaticResource.isCanonical(fullPath = "/cedrus-catalog/" + path)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        URL resource = this.getClass().getResource(fullPath);
        if (resource == null) {
            resource = this.getClass().getResource("/cedrus-catalog/index.html");
        }
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)resource.openStream(), (String)servletContext.getMimeType(resource.toString())).build();
    }

    private static boolean isCanonical(String fullPath) {
        try {
            return new URI(fullPath).normalize().getPath().equals(fullPath);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

