/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.event.client.EventBinder;
import io.airlift.http.server.EnableCaseSensitiveHeaderCache;
import io.airlift.http.server.EnableLegacyUriCompliance;
import io.airlift.http.server.EnableVirtualThreads;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.LocalAnnouncementHttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.TheAdminServlet;
import io.airlift.http.server.TheServlet;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import jakarta.servlet.Filter;
import java.util.Optional;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;
import ru.cedrusdata.catalog.config.CatalogServerConfig;
import ru.cedrusdata.catalog.server.CatalogHttpServerProvider;

public class CatalogHttpServerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogServerConfig.class);
        binder.bind(NodeInfo.class).in(Scopes.SINGLETON);
        binder.bind(HttpServer.class).toProvider(CatalogHttpServerProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpServer.ClientCertificate.class).setDefault().toInstance((Object)HttpServer.ClientCertificate.NONE);
        ExportBinder.newExporter((Binder)binder).export(HttpServer.class).as(generator -> generator.generatedNameOf(HttpServer.class, "cedrusdata-catalog"));
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(RequestStats.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableVirtualThreads.class)).setDefault().toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableLegacyUriCompliance.class)).setDefault().toInstance((Object)false);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheAdminServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        OptionalBinder.newOptionalBinder((Binder)binder, SslContextFactory.Server.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableCaseSensitiveHeaderCache.class)).setDefault().toInstance((Object)false);
        ExportBinder.newExporter((Binder)binder).export(RequestStats.class).as(generator -> generator.generatedNameOf(RequestStats.class, "cedrusdata-catalog"));
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{HttpRequestEvent.class});
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public NodeConfig getNodeConfig(CatalogServerConfig config) {
        return config.toAirliftNodeConfig();
    }

    @Provides
    @Singleton
    public HttpServerConfig getHttpConfig(CatalogServerConfig config) {
        return config.toAirliftHttpConfig();
    }

    @Provides
    @Singleton
    public Optional<HttpsConfig> getHttpsConfig(CatalogServerConfig config) {
        return config.toAirliftHttpsConfig();
    }
}

