/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.plugin;

import java.util.EnumMap;
import java.util.Set;

public class ExtensionPropertyClassifier<T extends Enum<T>> {
    private final EnumMap<T, Set<String>> redactedPropertyKeys;

    private ExtensionPropertyClassifier(EnumMap<T, Set<String>> redactedPropertyKeys) {
        this.redactedPropertyKeys = redactedPropertyKeys;
    }

    public boolean shouldRedact(T type, String propertyName) {
        return this.redactedPropertyKeys.get(type).contains(propertyName);
    }

    public static class Builder<T extends Enum<T>> {
        private final EnumMap<T, Set<String>> allRedactedPropertyKeys;

        public Builder(Class<T> type) {
            this.allRedactedPropertyKeys = new EnumMap(type);
        }

        public Builder<T> add(T type, Set<String> redactedPropertyKeys) {
            this.allRedactedPropertyKeys.put(type, redactedPropertyKeys);
            return this;
        }

        public ExtensionPropertyClassifier<T> build() {
            return new ExtensionPropertyClassifier<T>(this.allRedactedPropertyKeys);
        }
    }
}

