/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerObjectPredicate;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIO;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIOFactory;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.iceberg.table.IcebergCatalog;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteTableForReuseResponseEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergExpiredCteTable;
import ru.cedrusdata.catalog.iceberg.table.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewForRewriteInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectExtendedDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectRestListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableKey;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableLockService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableUtils;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationContext;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;

public class IcebergTableService {
    private static final Logger log = Logger.get(IcebergTableService.class);
    private final IcebergCatalogService catalogService;
    private final IcebergNamespaceService namespaceService;
    private final IcebergInternalTableService tableService;
    private final IcebergTableLockService tableLockService;
    private final Authorizer authorizer;

    @Inject
    public IcebergTableService(IcebergCatalogService catalogService, IcebergNamespaceService namespaceService, IcebergInternalTableService tableService, IcebergTableLockService tableLockService, Authorizer authorizer) {
        this.catalogService = Objects.requireNonNull(catalogService, "catalogService");
        this.namespaceService = Objects.requireNonNull(namespaceService, "namespaceService");
        this.tableService = Objects.requireNonNull(tableService, "tableService");
        this.tableLockService = Objects.requireNonNull(tableLockService, "tableLockService");
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
    }

    public LoadTableResponse restCreateTable(AuthenticatedPrincipal principal, String catalogName, String namespaceName, CreateTableRequest request, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(request.name());
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedTableName);
                return this.tableLockService.withWriteLock(lockKey, () -> {
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.empty(), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        if (request.stageCreate()) {
                            this.authorizeStageCreate(principal, (IcebergNamespaceContext)namespaceContext, request);
                            LoadTableResponse loadTableResponse = CatalogHandlers.stageTableCreate((Catalog)catalog, (Namespace)namespaceContext.icebergNamespace(), (CreateTableRequest)request);
                            return loadTableResponse;
                        }
                        LoadTableResponse loadTableResponse = CatalogHandlers.createTable((Catalog)catalog, (Namespace)namespaceContext.icebergNamespace(), (CreateTableRequest)request);
                        return loadTableResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(normalizedNamespaceName);
        }
    }

    private void authorizeStageCreate(AuthenticatedPrincipal principal, IcebergNamespaceContext namespaceContext, CreateTableRequest request) {
        boolean mv = IcebergTableUtils.isMaterializedView(request.properties());
        AuthorizerObjectType authorizerObjectType = mv ? AuthorizerObjectType.MATERIALIZED_VIEW : AuthorizerObjectType.TABLE;
        this.authorizer.authorizeObjectCreate(principal, namespaceContext.toSecurable(), authorizerObjectType);
    }

    public LoadTableResponse restRegisterTable(AuthenticatedPrincipal principal, String catalogName, String namespaceName, RegisterTableRequest request, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(request.name());
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedTableName);
                return this.tableLockService.withWriteLock(lockKey, () -> {
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.empty(), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        LoadTableResponse loadTableResponse = CatalogHandlers.registerTable((Catalog)catalog, (Namespace)namespaceContext.icebergNamespace(), (RegisterTableRequest)request);
                        return loadTableResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(normalizedNamespaceName);
        }
    }

    public LoadViewResponse restCreateView(AuthenticatedPrincipal principal, String catalogName, String namespaceName, CreateViewRequest request, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedViewName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(request.name());
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, normalizedViewName), () -> {
                try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.empty(), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                    LoadViewResponse loadViewResponse = CatalogHandlers.createView((ViewCatalog)catalog, (Namespace)namespaceContext.icebergNamespace(), (CreateViewRequest)request);
                    return loadViewResponse;
                }
            }));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(normalizedNamespaceName);
        }
    }

    public LoadTableResponse restUpdateTable(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String tableName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableName);
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedTableName);
                return this.tableLockService.withWriteLock(lockKey, () -> {
                    boolean create = request.requirements().stream().anyMatch(UpdateRequirement.AssertTableDoesNotExist.class::isInstance);
                    Optional<IcebergObjectExtendedDetails> details = create ? Optional.empty() : Optional.of(this.details((IcebergNamespaceContext)namespaceContext, normalizedTableName, IcebergTableType.TABLE));
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, details, (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        LoadTableResponse loadTableResponse = CatalogHandlers.updateTable((Catalog)catalog, (TableIdentifier)namespaceContext.icebergTable(normalizedTableName), (UpdateTableRequest)request);
                        return loadTableResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedTableName, Optional.of(CedrusDataIcebergObjectType.TABLE.caption()));
        }
    }

    public LoadViewResponse restUpdateView(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String viewName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedViewName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(viewName);
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, viewName);
                return this.tableLockService.withWriteLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, normalizedViewName, IcebergTableType.VIEW);
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        LoadViewResponse loadViewResponse = CatalogHandlers.updateView((ViewCatalog)catalog, (TableIdentifier)namespaceContext.icebergTable(normalizedViewName), (UpdateTableRequest)request);
                        return loadViewResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedViewName, Optional.of(CedrusDataIcebergObjectType.VIEW.caption()));
        }
    }

    public void restRenameTable(AuthenticatedPrincipal principal, String catalogName, RenameTableRequest request) {
        this.restRenameObject(principal, catalogName, request, IcebergTableType.TABLE);
    }

    public void restRenameView(AuthenticatedPrincipal principal, String catalogName, RenameTableRequest request) {
        this.restRenameObject(principal, catalogName, request, IcebergTableType.VIEW);
    }

    private void restRenameObject(AuthenticatedPrincipal principal, String catalogName, RenameTableRequest request, IcebergTableType type) {
        String normalizedSourceNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(request.source().namespace().level(0));
        String normalizedSourceObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(request.source().name());
        String normalizedDestinationNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(request.destination().namespace().level(0));
        String normalizedDestinationObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(request.destination().name());
        try {
            this.catalogService.execute(principal, catalogName, catalogContext -> {
                AtomicBoolean sourceNamespaceFound = new AtomicBoolean(false);
                try {
                    this.namespaceService.execute((IcebergCatalogContext)catalogContext, normalizedSourceNamespaceName, sourceNamespaceContext -> {
                        sourceNamespaceFound.set(true);
                        this.namespaceService.execute((IcebergCatalogContext)catalogContext, normalizedDestinationNamespaceName, destinationNamespaceContext -> {
                            IcebergTableKey sourceKey = IcebergTableService.lockKey(sourceNamespaceContext, normalizedSourceObjectName);
                            IcebergTableKey destinationKey = IcebergTableService.lockKey(destinationNamespaceContext, normalizedDestinationObjectName);
                            this.tableLockService.withWriteLock(sourceKey, destinationKey, () -> {
                                boolean renamed;
                                IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)sourceNamespaceContext, normalizedSourceObjectName, type);
                                ObjectInternalSecurable objectSecurable = details.toSecurable(sourceNamespaceContext.toSecurable());
                                this.authorizer.authorizeObjectAlter(principal, objectSecurable);
                                if (!sourceNamespaceContext.namespaceId().equals(destinationNamespaceContext.namespaceId())) {
                                    this.authorizer.authorizeObjectCreate(principal, destinationNamespaceContext.toSecurable(), AuthorizerObjectType.fromSecurableType(objectSecurable.type()));
                                }
                                if (!(renamed = this.tableService.rename(catalogContext.catalogName(), (IcebergNamespaceContext)sourceNamespaceContext, normalizedSourceObjectName, details.objectId(), (IcebergNamespaceContext)destinationNamespaceContext, normalizedDestinationObjectName, type))) {
                                    throw IcebergTableService.tableOrViewNotExists(normalizedSourceNamespaceName, normalizedSourceObjectName, type);
                                }
                            });
                            return null;
                        });
                        return null;
                    });
                }
                catch (IcebergNamespaceDoesNotExistException e) {
                    throw sourceNamespaceFound.get() ? e : IcebergTableService.tableOrViewNotExists(normalizedSourceNamespaceName, normalizedSourceObjectName, type);
                }
                return null;
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedSourceNamespaceName, normalizedSourceObjectName, type);
        }
    }

    public void restDropTable(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String tableName, boolean purge, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableName);
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedTableName);
                this.tableLockService.withWriteLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, normalizedTableName, IcebergTableType.TABLE);
                    this.authorizer.authorizeObjectDrop(principal, details.toSecurable(namespaceContext.toSecurable()));
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        if (purge) {
                            CatalogHandlers.purgeTable((Catalog)catalog, (TableIdentifier)namespaceContext.icebergTable(normalizedTableName));
                        } else {
                            CatalogHandlers.dropTable((Catalog)catalog, (TableIdentifier)namespaceContext.icebergTable(normalizedTableName));
                        }
                    }
                });
                return null;
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedNamespaceName, normalizedTableName, IcebergTableType.TABLE);
        }
    }

    public void restDropView(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String viewName, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedViewName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(viewName);
        IcebergTableService.failIfReadOnly(icebergOptions);
        try {
            this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedViewName);
                this.tableLockService.withWriteLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, normalizedViewName, IcebergTableType.VIEW);
                    this.authorizer.authorizeObjectDrop(principal, details.toSecurable(namespaceContext.toSecurable()));
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        CatalogHandlers.dropView((ViewCatalog)catalog, (TableIdentifier)namespaceContext.icebergTable(normalizedViewName));
                    }
                });
                return null;
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedNamespaceName, normalizedViewName, IcebergTableType.VIEW);
        }
    }

    public LoadTableResponse restLoadTable(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String tableName, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableName);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedTableName);
                return this.tableLockService.withReadLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, normalizedTableName, IcebergTableType.TABLE);
                    this.authorizer.authorizeObjectDescribe(principal, details.toSecurable(namespaceContext.toSecurable()));
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        LoadTableResponse loadTableResponse = this.loadTableInternal(catalog, namespaceContext.namespaceName(), namespaceContext.icebergTable(normalizedTableName), icebergOptions);
                        return loadTableResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedNamespaceName, normalizedTableName, IcebergTableType.TABLE);
        }
    }

    public LoadViewResponse restLoadView(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String viewName, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedViewName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(viewName);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedViewName);
                return this.tableLockService.withReadLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, normalizedViewName, IcebergTableType.VIEW);
                    this.authorizer.authorizeObjectDescribe(principal, details.toSecurable(namespaceContext.toSecurable()));
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                        LoadViewResponse loadViewResponse = this.loadViewInternal(catalog, namespaceContext.namespaceName(), namespaceContext.icebergTable(normalizedViewName), icebergOptions);
                        return loadViewResponse;
                    }
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedNamespaceName, normalizedViewName, IcebergTableType.VIEW);
        }
    }

    public LoadObjectResponse restLoadObject(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String objectName, IcebergOptions icebergOptions) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedObjectName);
                return this.tableLockService.withReadLock(lockKey, () -> {
                    TableIdentifier identifier = namespaceContext.icebergTable(normalizedObjectName);
                    Optional<IcebergObjectDetails> tableDetails = this.tableService.details((IcebergNamespaceContext)namespaceContext, normalizedObjectName, IcebergTableType.TABLE);
                    if (tableDetails.isPresent()) {
                        IcebergObjectExtendedDetails extendedTableDetails = new IcebergObjectExtendedDetails(tableDetails.get().objectId(), Optional.ofNullable(tableDetails.get().ownerId()), normalizedObjectName, tableDetails.get().mv() ? AuthorizerObjectType.MATERIALIZED_VIEW : AuthorizerObjectType.TABLE, tableDetails.get().metadataLocation());
                        this.authorizer.authorizeObjectDescribe(principal, extendedTableDetails.toSecurable(namespaceContext.toSecurable()));
                        try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(extendedTableDetails), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                            LoadTableResponse response = this.loadTableInternal(catalog, namespaceContext.namespaceName(), identifier, icebergOptions);
                            LoadObjectResponse loadObjectResponse = new LoadObjectResponse(identifier, Optional.of(response.tableMetadata()), Optional.of(response.metadataLocation()), Optional.empty(), Optional.empty());
                            return loadObjectResponse;
                        }
                    }
                    Optional<IcebergObjectDetails> viewDetails = this.tableService.details((IcebergNamespaceContext)namespaceContext, normalizedObjectName, IcebergTableType.VIEW);
                    if (viewDetails.isPresent()) {
                        IcebergObjectExtendedDetails extendedViewDetails = new IcebergObjectExtendedDetails(viewDetails.get().objectId(), Optional.ofNullable(viewDetails.get().ownerId()), normalizedObjectName, AuthorizerObjectType.VIEW, viewDetails.get().metadataLocation());
                        this.authorizer.authorizeObjectDescribe(principal, extendedViewDetails.toSecurable(namespaceContext.toSecurable()));
                        try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(extendedViewDetails), (CatalogIcebergFileIOFactory)ioFactory, icebergOptions);){
                            LoadViewResponse response = this.loadViewInternal(catalog, namespaceContext.namespaceName(), identifier, icebergOptions);
                            LoadObjectResponse loadObjectResponse = new LoadObjectResponse(identifier, Optional.empty(), Optional.empty(), Optional.of(response.metadata()), Optional.of(response.metadataLocation()));
                            return loadObjectResponse;
                        }
                    }
                    return new LoadObjectResponse(identifier, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(normalizedNamespaceName);
        }
    }

    private LoadTableResponse loadTableInternal(IcebergCatalog catalog, String namespaceName, TableIdentifier identifier, IcebergOptions options) {
        LoadTableResponse response = CatalogHandlers.loadTable((Catalog)catalog, (TableIdentifier)identifier);
        if (options.asOfTimestamp().isPresent()) {
            Optional<LoadTableResponse> adjustedResponse = IcebergTableUtils.applyAsOfToTableResponse(response, options.asOfTimestamp().get());
            if (adjustedResponse.isEmpty()) {
                throw IcebergTableService.tableOrViewNotExists(namespaceName, identifier.name(), IcebergTableType.TABLE);
            }
            response = adjustedResponse.get();
        }
        return response;
    }

    private LoadViewResponse loadViewInternal(IcebergCatalog catalog, String namespaceName, TableIdentifier identifier, IcebergOptions options) {
        LoadViewResponse response = CatalogHandlers.loadView((ViewCatalog)catalog, (TableIdentifier)identifier);
        if (options.asOfTimestamp().isPresent()) {
            Optional<LoadViewResponse> adjustedResponse = IcebergTableUtils.applyAsOfToViewResponse(response, options.asOfTimestamp().get());
            if (adjustedResponse.isEmpty()) {
                throw IcebergTableService.tableOrViewNotExists(namespaceName, identifier.name(), IcebergTableType.VIEW);
            }
            response = adjustedResponse.get();
        }
        return response;
    }

    public void restTableExists(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String tableName) {
        this.restObjectExists(principal, catalogName, namespaceName, tableName, IcebergTableType.TABLE);
    }

    public void restViewExists(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String viewName) {
        this.restObjectExists(principal, catalogName, namespaceName, viewName, IcebergTableType.VIEW);
    }

    private void restObjectExists(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String name, IcebergTableType type) {
        String normalizedName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(name);
        try {
            this.namespaceService.execute(principal, catalogName, namespaceName, namespaceContext -> {
                this.tableLockService.withReadLock(IcebergTableService.lockKey(namespaceContext, normalizedName), () -> this.details((IcebergNamespaceContext)namespaceContext, normalizedName, type));
                return null;
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, type);
        }
    }

    public ListTablesResponse restListTables(AuthenticatedPrincipal principal, String catalogName, String namespaceName, ResultPage page) {
        try {
            return this.namespaceService.execute(principal, catalogName, namespaceName, namespaceContext -> {
                AuthorizerObjectPredicate authorizerPredicate = this.authorizer.authorizeObjectList(principal);
                Predicate<IcebergObjectRestListResult.Entry> predicate = entry -> authorizerPredicate.test(entry.toSecurable());
                return this.tableService.listForRest((IcebergNamespaceContext)namespaceContext, IcebergTableType.TABLE, page, predicate);
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public ListTablesResponse restListViews(AuthenticatedPrincipal principal, String catalogName, String namespaceName, ResultPage page) {
        try {
            return this.namespaceService.execute(principal, catalogName, namespaceName, namespaceContext -> {
                AuthorizerObjectPredicate authorizerPredicate = this.authorizer.authorizeObjectList(principal);
                Predicate<IcebergObjectRestListResult.Entry> predicate = entry -> authorizerPredicate.test(entry.toSecurable());
                return this.tableService.listForRest((IcebergNamespaceContext)namespaceContext, IcebergTableType.VIEW, page, predicate);
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public Map<String, String> executeTableMaintenanceOperation(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String tableName, UUID tableId, CatalogComputeEngineOperationFactory operationFactory, CatalogComputeEngineOperationContext operationContext) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableName);
        try {
            if (operationFactory.loadTable()) {
                return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, tableName, IcebergTableType.TABLE, tableId);
                    try (IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext, Optional.of(details), (CatalogIcebergFileIOFactory)ioFactory, IcebergOptions.DEFAULT);){
                        Table icebergTable = catalog.loadTable(namespaceContext.icebergTable(normalizedTableName));
                        CatalogTable table = new CatalogTable(normalizedCatalogName, normalizedNamespaceName, normalizedTableName, Optional.of(((CatalogIcebergFileIO)icebergTable.io()).fileSystem()), Optional.of(icebergTable));
                        Map map = operationFactory.createTableOperation(table).execute(operationContext);
                        return map;
                    }
                });
            }
            return this.namespaceService.execute(principal, normalizedCatalogName, normalizedNamespaceName, namespaceContext -> {
                this.details((IcebergNamespaceContext)namespaceContext, tableName, IcebergTableType.TABLE, tableId);
                CatalogTable table = new CatalogTable(normalizedCatalogName, normalizedNamespaceName, normalizedTableName, Optional.empty(), Optional.empty());
                return operationFactory.createTableOperation(table).execute(operationContext);
            });
        }
        catch (NoSuchTableException | IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, tableName, IcebergTableType.TABLE);
        }
    }

    public boolean grantOwnership(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String objectName, AuthorizerObjectType objectType, AuthenticatedPrincipal newOwnerPrincipal) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        try {
            return this.namespaceService.executeWithIo(principal, normalizedCatalogName, normalizedNamespaceName, (namespaceContext, ioFactory) -> {
                IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, normalizedObjectName);
                return this.tableLockService.withWriteLock(lockKey, () -> {
                    IcebergObjectExtendedDetails details = this.details((IcebergNamespaceContext)namespaceContext, objectName, objectType.physicalType());
                    if (details.objectType() != objectType) {
                        throw new CatalogBadRequestException(String.format("Requested %s owner change, but referenced object is %s", new Object[]{objectType, details.objectType()}));
                    }
                    this.authorizer.authorizeGrantOwnership(principal, details.toSecurable(namespaceContext.toSecurable()));
                    if (newOwnerPrincipal.id().equals(details.objectOwnerId().orElse(null))) {
                        return false;
                    }
                    return this.tableService.updateOwnerIfExists((IcebergNamespaceContext)namespaceContext, normalizedObjectName, details.objectId(), newOwnerPrincipal.id(), objectType.physicalType());
                });
            });
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedNamespaceName, normalizedObjectName, IcebergTableType.VIEW);
        }
    }

    public void dropExpiredCteTables(AuthenticatedPrincipal principal, IcebergCatalogDetails catalogDetails, long currentTime) {
        this.catalogService.executeWithIo(principal, catalogDetails, (catalogContext, ioFactory) -> {
            List<IcebergExpiredCteTable> tables = this.tableService.expiredCteTables(catalogContext.catalogId(), currentTime);
            if (tables.isEmpty()) {
                return null;
            }
            HashMap<String, List> namespaceToTables = new HashMap<String, List>();
            for (IcebergExpiredCteTable icebergExpiredCteTable : tables) {
                namespaceToTables.computeIfAbsent(icebergExpiredCteTable.namespaceName(), ignored -> new ArrayList()).add(icebergExpiredCteTable);
            }
            for (Map.Entry entry : namespaceToTables.entrySet()) {
                this.dropExpiredCteTables(principal, (IcebergCatalogContext)catalogContext, (CatalogIcebergFileIOFactory)ioFactory, (String)entry.getKey(), (List)entry.getValue());
            }
            return null;
        });
    }

    public void dropExpiredCteTables(AuthenticatedPrincipal principal, IcebergCatalogContext catalogContext, CatalogIcebergFileIOFactory ioFactory, String namespaceName, List<IcebergExpiredCteTable> tables) {
        try {
            this.namespaceService.executeWithIo(catalogContext, ioFactory, namespaceName, (namespaceContext, ioFactory2) -> {
                for (IcebergExpiredCteTable table : tables) {
                    this.dropExpiredCteTable(principal, (IcebergNamespaceContext)namespaceContext, ioFactory, table);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to drop expired CTE tables from namespace \"%s.%s\" via principal \"%s\"", new Object[]{catalogContext.catalogName(), namespaceName, principal.name()});
        }
    }

    private void dropExpiredCteTable(AuthenticatedPrincipal principal, IcebergNamespaceContext namespaceContext, CatalogIcebergFileIOFactory ioFactory, IcebergExpiredCteTable table) {
        try {
            IcebergTableKey lockKey = IcebergTableService.lockKey(namespaceContext, table.objectName());
            this.tableLockService.withWriteLock(lockKey, () -> {
                IcebergObjectExtendedDetails details = this.details(namespaceContext, table.objectName(), IcebergTableType.TABLE);
                this.authorizer.authorizeObjectDrop(principal, details.toSecurable(namespaceContext.toSecurable()));
                try (IcebergCatalog catalog = this.asCatalog(namespaceContext, Optional.of(details), ioFactory, IcebergOptions.DEFAULT);){
                    CatalogHandlers.purgeTable((Catalog)catalog, (TableIdentifier)namespaceContext.icebergTable(table.objectName()));
                    log.debug("Dropped expired CTE table \"%s.%s.%s\" via principal \"%s\"", new Object[]{namespaceContext.catalogContext().catalogName(), table.namespaceName(), table.objectName(), principal.name()});
                }
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to drop expired CTE table \"%s.%s.%s\" via principal \"%s\"", new Object[]{namespaceContext.catalogContext().catalogName(), table.namespaceName(), table.objectName(), principal.name()});
        }
    }

    public IcebergObjectInfo info(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String objectName) {
        return this.resolveObject(principal, catalogName, namespaceName, objectName, IcebergObjectInfoEx::info);
    }

    public UUID resolveIdForMaintenance(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String objectName) {
        return this.resolveObject(principal, catalogName, namespaceName, objectName, IcebergObjectInfoEx::objectId);
    }

    private <T> T resolveObject(AuthenticatedPrincipal principal, String catalogName, String namespaceName, String objectName, Function<IcebergObjectInfoEx, T> converter) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        try {
            return (T)this.catalogService.execute(principal, normalizedCatalogName, catalogContext -> this.namespaceService.execute((IcebergCatalogContext)catalogContext, normalizedNamespaceName, namespaceContext -> {
                Optional<IcebergObjectInfoEx> maybeInfo = this.tableService.infoByName(catalogContext.catalogId(), namespaceContext.namespaceId(), normalizedObjectName);
                if (maybeInfo.isEmpty()) {
                    throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedObjectName);
                }
                ObjectInternalSecurable securable = maybeInfo.get().toSecurable();
                this.authorizer.authorizeObjectDescribe(principal, securable);
                return converter.apply(maybeInfo.get());
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedObjectName);
        }
    }

    public IcebergObjectListResponse list(AuthenticatedPrincipal principal, Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        catalogName = catalogName.map(CatalogObjectNameValidation.VALIDATION_CATALOG::normalizeObjectName);
        namespaceName = namespaceName.map(CatalogObjectNameValidation.VALIDATION_NAMESPACE::normalizeObjectName);
        AuthorizerObjectPredicate authorizerPredicate = this.authorizer.authorizeObjectList(principal);
        Predicate<IcebergObjectInfoEx> predicate = entry -> authorizerPredicate.test(entry.toSecurable());
        return this.tableService.list(catalogName, namespaceName, objectType, page, predicate);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(AuthenticatedPrincipal principal, String catalogName, Set<String> tableNames) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        return this.catalogService.execute(principal, normalizedCatalogName, catalogContext -> {
            AuthorizerObjectPredicate authorizerPredicate = this.authorizer.authorizeObjectList(principal);
            Predicate<IcebergMaterializedViewForRewriteInfoEx> predicate = entry -> authorizerPredicate.test(entry.toSecurable(catalogContext.toSecurable()));
            return this.tableService.listMaterializedViewsForRewrite(catalogContext.catalogId(), tableNames, predicate);
        });
    }

    public IcebergCteTableForReuseResponse cteTableForReuse(AuthenticatedPrincipal principal, String catalogName, String canonicalPlan, long minRemainingTtl) {
        String normalizedCatalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(catalogName);
        return this.catalogService.execute(principal, normalizedCatalogName, catalogContext -> {
            AuthorizerObjectPredicate authorizerPredicate;
            boolean authorized;
            Optional<IcebergCteTableForReuseResponseEx> response = this.tableService.cteTableForReuse(catalogContext.catalogId(), canonicalPlan, minRemainingTtl);
            if (response.isPresent() && (authorized = (authorizerPredicate = this.authorizer.authorizeObjectList(principal)).test(response.get().toSecurable()))) {
                return new IcebergCteTableForReuseResponse(response.get().namespaceName(), response.get().tableName());
            }
            return new IcebergCteTableForReuseResponse(null, null);
        });
    }

    private IcebergCatalog asCatalog(IcebergNamespaceContext namespaceContext, Optional<IcebergObjectExtendedDetails> objectDetails, CatalogIcebergFileIOFactory ioFactory, IcebergOptions icebergOptions) {
        return this.tableService.asCatalog(this.authorizer, namespaceContext, objectDetails, ioFactory, icebergOptions);
    }

    @VisibleForTesting
    public Table loadTableForTest(IcebergNamespaceContext namespaceContext, CatalogIcebergFileIOFactory ioFactory, TableIdentifier tableIdentifier, IcebergOptions options) {
        if (options.asOfTimestamp().isPresent()) {
            throw new IllegalArgumentException("This method doesn't support \"as of\" semantics (please add the support if needed)");
        }
        IcebergObjectExtendedDetails details = this.details(namespaceContext, tableIdentifier.name(), IcebergTableType.TABLE);
        try (IcebergCatalog catalog = this.asCatalog(namespaceContext, Optional.of(details), ioFactory, options);){
            Table table = catalog.loadTable(tableIdentifier);
            return table;
        }
    }

    private IcebergObjectExtendedDetails details(IcebergNamespaceContext namespaceContext, String objectName, IcebergTableType type) {
        Optional<IcebergObjectExtendedDetails> details = this.optionalDetails(namespaceContext, objectName, type);
        if (details.isEmpty()) {
            throw IcebergTableService.tableOrViewNotExists(namespaceContext.namespaceName(), CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName), type);
        }
        return details.get();
    }

    private IcebergObjectExtendedDetails details(IcebergNamespaceContext namespaceContext, String objectName, IcebergTableType type, UUID expectedId) {
        IcebergObjectExtendedDetails details = this.details(namespaceContext, objectName, type);
        if (!expectedId.equals(details.objectId())) {
            throw IcebergTableService.tableOrViewNotExists(namespaceContext.namespaceName(), objectName, IcebergTableType.TABLE);
        }
        return details;
    }

    private Optional<IcebergObjectExtendedDetails> optionalDetails(IcebergNamespaceContext namespaceContext, String objectName, IcebergTableType type) {
        String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        Optional<IcebergObjectDetails> maybeDetails = this.tableService.details(namespaceContext, normalizedObjectName, type);
        return maybeDetails.map(details -> {
            AuthorizerObjectType authorizerType = type == IcebergTableType.TABLE ? (details.mv() ? AuthorizerObjectType.MATERIALIZED_VIEW : AuthorizerObjectType.TABLE) : AuthorizerObjectType.VIEW;
            return new IcebergObjectExtendedDetails(details.objectId(), Optional.ofNullable(details.ownerId()), objectName, authorizerType, details.metadataLocation());
        });
    }

    private static IcebergNamespaceDoesNotExistException namespaceNotExists(String namespaceName) {
        return new IcebergNamespaceDoesNotExistException(CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName));
    }

    private static CatalogException tableOrViewNotExists(String namespaceName, String objectName, IcebergTableType tableType) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        Optional<String> objectType = tableType == IcebergTableType.TABLE ? Optional.of(CedrusDataIcebergObjectType.TABLE.caption()) : (tableType == IcebergTableType.VIEW ? Optional.of(CedrusDataIcebergObjectType.VIEW.caption()) : Optional.empty());
        throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedObjectName, objectType);
    }

    private static IcebergTableKey lockKey(IcebergNamespaceContext namespaceContext, String name) {
        name = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(name);
        return new IcebergTableKey(namespaceContext.catalogContext().catalogId(), namespaceContext.namespaceId(), name);
    }

    private static void failIfReadOnly(IcebergOptions icebergOptions) {
        if (icebergOptions.asOfTimestamp().isPresent()) {
            throw new CatalogBadRequestException(String.format("Catalog is read-only when \"%s\" header is set", "X-CedrusData-As-Of-Timestamp"));
        }
    }
}

